/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.network;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.impl.network.message.ClientMessages;
import com.blamejared.crafttweaker.impl.network.message.IMessage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class PacketHandler {
    public static SimpleChannel CHANNEL = ChannelBuilder.named((ResourceLocation)CraftTweakerConstants.rl("main")).acceptedVersions(Channel.VersionTest.exact((int)1)).networkProtocolVersion(1).simpleChannel();
    private static int ID = 0;

    public static void init() {
        for (ClientMessages msg : ClientMessages.values()) {
            PacketHandler.registerMessage(msg.getMessageClass(), msg.getMessageFactory(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    private static <MSG extends IMessage> void registerMessage(Class<MSG> messageType, Function<FriendlyByteBuf, MSG> decoder, @Nullable NetworkDirection direction) {
        PacketHandler.registerMessage(messageType, decoder, (messageCopy, contextSupplier) -> PacketHandler.andHandling(contextSupplier, messageCopy::handle), direction);
    }

    private static <MSG extends IMessage> void registerMessage(Class<MSG> messageType, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, CustomPayloadEvent.Context> messageConsumer, @Nullable NetworkDirection direction) {
        CHANNEL.messageBuilder(messageType, ID++, direction).encoder(IMessage::m_293110_).decoder(decoder).consumerNetworkThread(messageConsumer).add();
    }

    private static void andHandling(CustomPayloadEvent.Context context, Runnable enqueuedWork) {
        context.enqueueWork(enqueuedWork);
        context.setPacketHandled(true);
    }
}

