/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.command.argument.RecipeTypeArgument;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessRecipeManager;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

public final class RecipeCommands {
    private RecipeCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("recipes", Component.m_237115_((String)"crafttweaker.command.description.recipes"), builder -> builder.executes(context -> RecipeCommands.dumpRecipes((CommandSourceStack)context.getSource())));
        handler.registerSubCommand("recipes", "hand", Component.m_237115_((String)"crafttweaker.command.description.recipes.hand"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            return RecipeCommands.dumpHand(source, player.m_21205_());
        }));
        handler.registerSubCommand("recipes", "inventory", Component.m_237115_((String)"crafttweaker.command.description.recipes.inventory"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            IntStream.range(0, player.m_150109_().m_6643_()).mapToObj(arg_0 -> ((Inventory)player.m_150109_()).m_8020_(arg_0)).filter(itemStack -> !itemStack.m_41619_()).forEach(itemStack -> {
                if (stacks.stream().noneMatch(stack -> ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)stack))) {
                    stacks.add((ItemStack)itemStack);
                }
            });
            return RecipeCommands.dump(source, stacks);
        }));
        handler.registerSubCommand("recipes", "manager", Component.m_237115_((String)"crafttweaker.command.description.recipes.manager"), builder -> builder.then(Commands.m_82129_((String)"type", (ArgumentType)RecipeTypeArgument.get()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            return RecipeCommands.dumpRecipes(source, (IRecipeManager)context.getArgument("type", IRecipeManager.class));
        })));
    }

    private static int dumpRecipes(CommandSourceStack source) {
        CommandUtilities.COMMAND_LOGGER.info("Dumping all recipes!");
        RecipeCommands.dumpRecipes(source, (RecipeType<?> it) -> true);
        CommandUtilities.send(source, CommandUtilities.openingLogFile(Component.m_237110_((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.m_237115_((String)"crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static int dumpRecipes(CommandSourceStack source, IRecipeManager<?> manager) {
        CommandUtilities.COMMAND_LOGGER.info("Dumping recipes for manager " + manager.getCommandString() + "!");
        RecipeType<?> type = manager.getRecipeType();
        RecipeCommands.dumpRecipes(source, (RecipeType<?> it) -> Objects.equals(it, type));
        CommandUtilities.send(source, CommandUtilities.openingLogFile(Component.m_237110_((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.m_237115_((String)"crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static int dumpHand(CommandSourceStack source, ItemStack stack) {
        return RecipeCommands.dump(source, List.of(stack));
    }

    private static int dump(CommandSourceStack source, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) {
                CommandUtilities.send(source, (Component)Component.m_237115_((String)"crafttweaker.command.recipes.hand.empty").m_130940_(ChatFormatting.RED));
                return 1;
            }
            IItemStack workingStack = IItemStack.of(stack.m_41777_()).setAmount(1);
            CommandUtilities.COMMAND_LOGGER.info("Dumping all recipes that output {}!", (Object)ItemStackUtil.getCommandString(workingStack.getInternal()));
            ((AccessRecipeManager)source.m_81372_().m_7465_()).crafttweaker$getRecipes().forEach((recipeType, map) -> RecipeCommands.dumpRecipe(recipeType, map.values(), it -> workingStack.matches(IItemStack.of(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((Recipe)it.f_291008_()).m_8043_(arg_0)))), true));
        }
        CommandUtilities.send(source, CommandUtilities.openingLogFile(Component.m_237110_((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.m_237115_((String)"crafttweaker.command.misc.recipes.list")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static void dumpRecipes(CommandSourceStack source, Predicate<RecipeType<?>> typeFilter) {
        ((AccessRecipeManager)source.m_81372_().m_7465_()).crafttweaker$getRecipes().entrySet().stream().filter(it -> typeFilter.test((RecipeType)it.getKey())).forEach(it -> RecipeCommands.dumpRecipe((RecipeType)it.getKey(), ((Map)it.getValue()).values(), recipe -> true, false));
    }

    private static void dumpRecipe(RecipeType<?> type, Collection<RecipeHolder<?>> recipes, Predicate<RecipeHolder<?>> filter, boolean hideEmpty) {
        IRecipeManager<Recipe<?>> manager = RecipeTypeBracketHandler.getOrDefault(type);
        if (manager == null) {
            return;
        }
        String dumpResult = recipes.stream().filter(filter).sorted(Comparator.comparing(RecipeCommands::serializer).thenComparing(RecipeHolder::f_291676_)).map(it -> RecipeCommands.dump((IRecipeManager)GenericUtil.uncheck(manager), it)).collect(Collectors.joining("\n  "));
        if (hideEmpty && dumpResult.isEmpty()) {
            return;
        }
        CommandUtilities.COMMAND_LOGGER.info("Recipe type: '{}'\n  {}\n", (Object)manager.getCommandString(), (Object)(dumpResult.isEmpty() ? "No recipe found" : dumpResult));
    }

    private static ResourceLocation serializer(RecipeHolder<?> recipe) {
        return Objects.requireNonNull(BuiltInRegistries.f_256769_.m_7981_((Object)recipe.f_291008_().m_7707_()));
    }

    private static <T extends Recipe<?>> String dump(IRecipeManager<? super T> manager, RecipeHolder<T> recipe) {
        return IRecipeHandlerRegistry.getHandlerFor(recipe).dumpToCommandString(manager, AccessibleElementsProvider.get().registryAccess(), recipe);
    }
}

