/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.command.argument.IItemStackArgument;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.natives.entity.type.player.ExpandPlayer;
import com.blamejared.crafttweaker.platform.services.IEventHelper;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class MiscCommands {
    private static final String DOCS = "https://docs.blamejared.com";
    private static final String DISCORD = "https://discord.blamejared.com";
    private static final String ISSUES = "https://github.com/CraftTweaker/CraftTweaker/issues";
    private static final String PATREON = "https://patreon.com/jaredlll08";

    private MiscCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("give", Component.m_237115_((String)"crafttweaker.command.description.give"), builder -> ((LiteralArgumentBuilder)builder.requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"item", (ArgumentType)IItemStackArgument.get()).executes(context -> {
            ExpandPlayer.give((Player)((CommandSourceStack)context.getSource()).m_81375_(), (IItemStack)context.getArgument("item", IItemStack.class), -1);
            return 1;
        })));
        handler.registerRootCommand("reload", Component.m_237115_((String)"crafttweaker.command.description.reload"), builder -> builder.executes(context -> {
            CommandUtilities.send((CommandSourceStack)context.getSource(), CommandUtilities.run(Component.m_237115_((String)"crafttweaker.command.misc.reload.info").m_130940_(ChatFormatting.AQUA), "/reload"));
            return 1;
        }));
        handler.registerRootCommand("discord", Component.m_237115_((String)"crafttweaker.command.description.discord"), builder -> builder.executes(context -> {
            CommandUtilities.send((CommandSourceStack)context.getSource(), CommandUtilities.openingUrl(Component.m_237110_((String)"crafttweaker.command.misc.link", (Object[])new Object[]{CommandUtilities.makeNoticeable(DISCORD)}).m_130940_(ChatFormatting.GREEN), DISCORD));
            return 1;
        }));
        handler.registerRootCommand("issues", Component.m_237115_((String)"crafttweaker.command.description.issues"), builder -> builder.executes(context -> {
            CommandUtilities.send((CommandSourceStack)context.getSource(), CommandUtilities.openingUrl(Component.m_237110_((String)"crafttweaker.command.misc.link", (Object[])new Object[]{CommandUtilities.makeNoticeable(ISSUES)}).m_130940_(ChatFormatting.GREEN), ISSUES));
            return 1;
        }));
        handler.registerRootCommand("patreon", Component.m_237115_((String)"crafttweaker.command.description.patreon"), builder -> builder.executes(context -> {
            CommandUtilities.send((CommandSourceStack)context.getSource(), CommandUtilities.openingUrl(Component.m_237110_((String)"crafttweaker.command.misc.link", (Object[])new Object[]{CommandUtilities.makeNoticeable(PATREON)}).m_130940_(ChatFormatting.GREEN), PATREON));
            return 1;
        }));
        Stream.of("wiki", "docs", "examples").forEach(id -> handler.registerRootCommand((String)id, Component.m_237115_((String)"crafttweaker.command.description.docs"), builder -> builder.executes(context -> {
            CommandUtilities.send((CommandSourceStack)context.getSource(), CommandUtilities.openingUrl(Component.m_237110_((String)"crafttweaker.command.misc.link", (Object[])new Object[]{CommandUtilities.makeNoticeable(DOCS)}).m_130940_(ChatFormatting.GREEN), DOCS));
            return 1;
        })));
        handler.registerRootCommand("ctgui", Component.m_237115_((String)"crafttweaker.command.description.docs"), builder -> builder.executes(context -> {
            CommandUtilities.send((CommandSourceStack)context.getSource(), (Component)Component.m_237115_((String)"crafttweaker.command.misc.ctgui"));
            return 1;
        }));
        handler.registerRootCommand("block_info", Component.m_237115_((String)"crafttweaker.command.description.info.block"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            if (IEventHelper.BLOCK_INFO_PLAYERS.contains(player)) {
                IEventHelper.BLOCK_INFO_PLAYERS.remove(player);
                CommandUtilities.send(source, (Component)Component.m_237115_((String)"crafttweaker.command.info.block.deactivated"));
            } else {
                IEventHelper.BLOCK_INFO_PLAYERS.add((Player)player);
                CommandUtilities.send(source, (Component)Component.m_237115_((String)"crafttweaker.command.info.block.activated"));
            }
            return 1;
        }));
        handler.registerRootCommand("entity_info", Component.m_237115_((String)"crafttweaker.command.description.info.entity"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            if (IEventHelper.ENTITY_INFO_PLAYERS.contains(player)) {
                IEventHelper.ENTITY_INFO_PLAYERS.remove(player);
                CommandUtilities.send(source, (Component)Component.m_237115_((String)"crafttweaker.command.info.entity.deactivated"));
            } else {
                IEventHelper.ENTITY_INFO_PLAYERS.add((Player)player);
                CommandUtilities.send(source, (Component)Component.m_237115_((String)"crafttweaker.command.info.entity.activated"));
            }
            return 1;
        }));
    }
}

