/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.visitor.DataToTextComponentVisitor;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.manager.type.KnownTagManager;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.mixin.common.access.entity.AccessAttributeModifier;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker.natives.entity.attribute.ExpandAttribute;
import com.blamejared.crafttweaker.natives.entity.equipment.ExpandEquipmentSlot;
import com.blamejared.crafttweaker.platform.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.util.TriConsumer;

public final class HandCommands {
    private HandCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("hand", Component.m_237115_((String)"crafttweaker.command.description.hand"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            ItemStack stack = player.m_21205_();
            Item item = stack.m_41720_();
            HandCommands.sendBasicItemInformation(source, stack);
            if (item instanceof BlockItem) {
                HandCommands.sendBlockInformation(source, (BlockItem)stack.m_41720_());
            }
            if (item instanceof BucketItem && Services.PLATFORM.getBucketContent((BucketItem)item) != Fluids.f_76191_) {
                HandCommands.sendBucketInformation(source, (BucketItem)stack.m_41720_());
            }
            for (MutableComponent component : Services.PLATFORM.getFluidsForDump(stack, (Player)player, InteractionHand.MAIN_HAND)) {
                HandCommands.sendHand(source, Component.m_237115_((String)"crafttweaker.command.misc.fluid"), component.getString());
            }
            HandCommands.sendTagsInformation(source, item);
            return 1;
        }));
        handler.registerSubCommand("hand", "registry_name", Component.m_237115_((String)"crafttweaker.command.description.hand.registryname"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ItemStack mainHandItem = source.m_81375_().m_21205_();
            HandCommands.sendCopyingHand(source, Component.m_237115_((String)"crafttweaker.command.misc.item"), BuiltInRegistries.f_257033_.m_7981_((Object)mainHandItem.m_41720_()).toString());
            return 1;
        }));
        handler.registerSubCommand("hand", "data", Component.m_237115_((String)"crafttweaker.command.description.hand.data"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            ItemStack stack = player.m_21205_();
            if (!stack.m_41782_()) {
                CommandUtilities.send(source, (Component)Component.m_237115_((String)"crafttweaker.command.hand.no.data"));
                return 0;
            }
            HandCommands.sendCopyingHand(source, Component.m_237115_((String)"crafttweaker.command.misc.data"), new MapData(stack.m_41783_()).accept(new DataToTextComponentVisitor(" ", 0)).getString());
            return 1;
        }));
        handler.registerSubCommand("hand", "tags", Component.m_237115_((String)"crafttweaker.command.description.hand.tags"), builder -> builder.executes(context -> {
            ServerPlayer player;
            ItemStack stack;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Collection<String> tags = HandCommands.sendTagsInformation(source, (stack = (player = source.m_81375_()).m_21205_()).m_41720_());
            if (tags.isEmpty()) {
                CommandUtilities.send(source, (Component)Component.m_237115_((String)"crafttweaker.command.hand.no.tags"));
                return 1;
            }
            tags.stream().findFirst().ifPresent(it -> CommandUtilities.copy(source, it));
            return 1;
        }));
        handler.registerSubCommand("hand", "vanilla", Component.m_237115_((String)"crafttweaker.command.description.hand.vanilla"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            ItemStack stack = player.m_21205_();
            Item item = stack.m_41720_();
            HandCommands.sendBasicVanillaItemInformation(source, stack);
            if (stack.m_41782_()) {
                HandCommands.sendVanillaDataInformation(source, (Tag)Objects.requireNonNull(stack.m_41783_()));
            }
            if (item instanceof BucketItem && Services.PLATFORM.getBucketContent((BucketItem)item) != Fluids.f_76191_) {
                HandCommands.sendVanillaBucketInformation(source, (BucketItem)stack.m_41720_());
            }
            HandCommands.sendVanillaTagsInformation(source, item);
            return 1;
        }));
        handler.registerSubCommand("hand", "attributes", Component.m_237115_((String)"crafttweaker.command.description.hand.attributes"), builder -> builder.executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            ItemStack stack = player.m_21205_();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                Map modifiers = stack.m_41638_(slot).asMap();
                if (modifiers.isEmpty()) continue;
                String equipmentCS = ExpandEquipmentSlot.getCommandString(slot);
                CommandUtilities.sendCopying(source, Component.m_237115_((String)"crafttweaker.command.hand.header.attributes").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)equipmentCS).m_130940_(ChatFormatting.GREEN)).m_130940_(ChatFormatting.DARK_AQUA), equipmentCS);
                modifiers.forEach((attribute, attributeModifiers) -> {
                    String attributeCS = ExpandAttribute.getCommandString(attribute);
                    CommandUtilities.sendCopying(source, Component.m_237113_((String)"- ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)attributeCS).m_130940_(ChatFormatting.GREEN)), attributeCS);
                    attributeModifiers.forEach(attributeModifier -> {
                        HandCommands.sendAttributePropertyInformation(source, "Name", ((AccessAttributeModifier)attribute).crafttweaker$getName());
                        HandCommands.sendAttributePropertyInformation(source, "ID", attributeModifier.m_22209_().toString());
                        HandCommands.sendAttributePropertyInformation(source, "Operation", attributeModifier.m_22217_().name());
                        HandCommands.sendAttributePropertyInformation(source, "Amount", String.valueOf(attributeModifier.m_22218_()));
                        HandCommands.sendAttributePropertyInformation(source, "IData", new MapData(attributeModifier.m_22219_()).asString());
                    });
                });
            }
            HandCommands.sendCopyingHand(source, Component.m_237115_((String)"crafttweaker.command.misc.item"), BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString());
            return 1;
        }));
    }

    private static void sendBasicItemInformation(CommandSourceStack source, ItemStack target) {
        String output = ItemStackUtil.getCommandString(target);
        HandCommands.sendCopyingHand(source, Component.m_237115_((String)"crafttweaker.command.misc.item"), output);
    }

    private static void sendBlockInformation(CommandSourceStack source, BlockItem target) {
        HandCommands.sendBlockInformation(source, target.m_40614_());
    }

    private static void sendBlockInformation(CommandSourceStack source, Block target) {
        HandCommands.sendHand(source, Component.m_237115_((String)"crafttweaker.command.misc.block"), ExpandBlock.getCommandString(target));
        HandCommands.sendHand(source, Component.m_237115_((String)"crafttweaker.command.misc.blockstate"), ExpandBlockState.getCommandString(target.m_49966_()));
    }

    private static void sendBucketInformation(CommandSourceStack source, BucketItem target) {
        if (Services.PLATFORM.getBucketContent(target) == Fluids.f_76191_) {
            return;
        }
        HandCommands.sendHand(source, Component.m_237115_((String)"crafttweaker.command.misc.fluidblockstate"), ExpandBlockState.getCommandString(Services.PLATFORM.getBucketContent(target).m_76145_().m_76188_()));
    }

    private static Collection<String> sendTagsInformation(CommandSourceStack source, Item item) {
        ArrayList<String> tags = new ArrayList<String>(HandCommands.sendItemTagsInformation(source, item));
        if (item instanceof BlockItem) {
            tags.addAll(HandCommands.sendBlockTagsInformation(source, (BlockItem)item));
        }
        return tags;
    }

    private static Collection<String> sendItemTagsInformation(CommandSourceStack source, Item item) {
        return HandCommands.sendTagsInformation(source, Component.m_237115_((String)"crafttweaker.command.hand.header.tags.item"), CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registries.f_256913_), item);
    }

    private static Collection<String> sendBlockTagsInformation(CommandSourceStack source, BlockItem item) {
        return HandCommands.sendTagsInformation(source, Component.m_237115_((String)"crafttweaker.command.hand.header.tags.block"), CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registries.f_256747_), item.m_40614_());
    }

    private static <T> Collection<String> sendTagsInformation(CommandSourceStack source, MutableComponent header, KnownTagManager<?> manager, T target) {
        Holder<T> tHolder = Services.REGISTRY.makeHolder(manager.resourceKey(), target);
        if (tHolder.m_203616_().findAny().isEmpty()) {
            return List.of();
        }
        CommandUtilities.send(source, (Component)header.m_130940_(ChatFormatting.DARK_AQUA));
        return tHolder.m_203616_().map(tTagKey -> new KnownTag(tTagKey.f_203868_(), manager)).map(MCTag::getCommandString).peek(it -> HandCommands.sendTagHand(source, it)).toList();
    }

    private static void sendBasicVanillaItemInformation(CommandSourceStack source, ItemStack target) {
        String output = Objects.requireNonNull(BuiltInRegistries.f_257033_.m_7981_((Object)target.m_41720_())).toString();
        HandCommands.sendCopyingHand(source, Component.m_237115_((String)"crafttweaker.command.misc.item"), output);
    }

    private static void sendVanillaDataInformation(CommandSourceStack source, Tag nbt) {
        HandCommands.sendHand(source, Component.m_237115_((String)"crafttweaker.command.misc.data"), nbt.toString());
    }

    private static void sendVanillaBucketInformation(CommandSourceStack source, BucketItem target) {
        if (Services.PLATFORM.getBucketContent(target) == Fluids.f_76191_) {
            return;
        }
        HandCommands.sendHand(source, Component.m_237115_((String)"crafttweaker.command.misc.fluidblockstate"), BuiltInRegistries.f_257020_.m_7981_((Object)Services.PLATFORM.getBucketContent(target)).toString());
    }

    private static void sendVanillaTagsInformation(CommandSourceStack source, Item item) {
        HandCommands.sendVanillaItemTagsInformation(source, item);
        if (item instanceof BlockItem) {
            HandCommands.sendVanillaBlockTagsInformation(source, (BlockItem)item);
        }
    }

    private static void sendVanillaItemTagsInformation(CommandSourceStack source, Item item) {
        HandCommands.sendVanillaTagsInformation(source, Component.m_237115_((String)"crafttweaker.command.hand.header.tags.item"), CraftTweakerTagRegistry.INSTANCE.tagManager(Registries.f_256913_), item);
    }

    private static void sendVanillaBlockTagsInformation(CommandSourceStack source, BlockItem item) {
        HandCommands.sendVanillaTagsInformation(source, Component.m_237115_((String)"crafttweaker.command.hand.header.tags.block"), CraftTweakerTagRegistry.INSTANCE.tagManager(Registries.f_256747_), item.m_40614_());
    }

    private static <T> void sendVanillaTagsInformation(CommandSourceStack source, MutableComponent header, ITagManager<?> manager, T target) {
        Holder<T> tHolder = Services.REGISTRY.makeHolder(manager.resourceKey(), target);
        if (tHolder.m_203616_().findAny().isEmpty()) {
            return;
        }
        CommandUtilities.send(source, (Component)header.m_130940_(ChatFormatting.DARK_AQUA));
        tHolder.m_203616_().map(tTagKey -> "#" + tTagKey.f_203868_()).forEach(it -> HandCommands.sendTagHand(source, it));
    }

    private static void sendAttributePropertyInformation(CommandSourceStack source, String propertyName, String value) {
        CommandUtilities.sendCopying(source, Component.m_237113_((String)"    - ").m_130946_(propertyName).m_130946_(": ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)value).m_130940_(ChatFormatting.AQUA)), value);
    }

    private static void sendHand(CommandSourceStack source, MutableComponent messagePrefix, String target) {
        HandCommands.sendHand(source, messagePrefix, target, (TriConsumer<CommandSourceStack, MutableComponent, String>)((TriConsumer)CommandUtilities::sendCopying));
    }

    private static void sendCopyingHand(CommandSourceStack source, MutableComponent messagePrefix, String target) {
        HandCommands.sendHand(source, messagePrefix, target, (TriConsumer<CommandSourceStack, MutableComponent, String>)((TriConsumer)CommandUtilities::sendCopyingAndCopy));
    }

    private static void sendHand(CommandSourceStack source, MutableComponent messagePrefix, String target, TriConsumer<CommandSourceStack, MutableComponent, String> consumer) {
        consumer.accept((Object)source, (Object)messagePrefix.m_130946_(": ").m_7220_((Component)Component.m_237113_((String)target).m_130940_(ChatFormatting.GREEN)), (Object)target);
    }

    private static void sendTagHand(CommandSourceStack source, String tag) {
        CommandUtilities.sendCopying(source, Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237113_((String)"- ").m_130940_(ChatFormatting.YELLOW)).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)tag).m_130940_(ChatFormatting.AQUA)), tag);
    }
}

