/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientEmpty;
import com.blamejared.crafttweaker.api.util.ArrayUtil;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class RecipeUtil {
    public static ShapedRecipePattern createPattern(IIngredient[][] ingredients) {
        int width = ArrayUtil.getMaxWidth(ingredients);
        int height = ingredients.length;
        return RecipeUtil.createPattern(ArrayUtil.flattenToNNL(width, height, ingredients, () -> Ingredient.f_43901_, IIngredient::asVanillaIngredient), width, height);
    }

    public static ShapedRecipePattern createPattern(NonNullList<Ingredient> flatIngredients, int width, int height) {
        char start = 'a';
        HashMap<Character, Ingredient> keys = new HashMap<Character, Ingredient>();
        LinkedList<String> pattern = new LinkedList<String>();
        int ingredientIndex = 0;
        for (int row = 0; row < height; ++row) {
            StringBuilder rowPattern = new StringBuilder();
            for (int col = 0; col < width; ++col) {
                Ingredient ingredient;
                if ((ingredient = (Ingredient)flatIngredients.get(ingredientIndex++)).m_43947_()) {
                    rowPattern.append(" ");
                    continue;
                }
                char c = start;
                start = (char)(start + 1);
                char key = c;
                keys.put(Character.valueOf(key), ingredient);
                rowPattern.append(key);
            }
            pattern.add(rowPattern.toString());
        }
        return ShapedRecipePattern.m_306906_(keys, pattern);
    }

    public static IIngredient[][] dissolvePattern(String[] pattern, Map<String, IIngredient> keys, int width, int height) {
        keys.put(" ", IIngredientEmpty.INSTANCE);
        IIngredient[][] ingredients = new IIngredient[height][width];
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int row = 0; row < pattern.length; ++row) {
            for (int col = 0; col < pattern[row].length(); ++col) {
                String s = pattern[row].substring(col, col + 1);
                IIngredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new IllegalArgumentException("Pattern references symbol '" + s + "' but it is not defined in the key");
                }
                set.remove(s);
                ingredients[row][col] = ingredient;
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return ingredients;
    }
}

