/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.serializer;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipe;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CTShapedRecipeSerializer
implements RecipeSerializer<CTShapedRecipe> {
    public static final CTShapedRecipeSerializer INSTANCE = new CTShapedRecipeSerializer();
    public static final Codec<CTShapedRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IItemStack.CODEC.fieldOf("output").forGetter(CTShapedRecipe::getCtOutput), (App)IIngredient.CODEC.listOf().listOf().fieldOf("ingredients").xmap(lists -> (IIngredient[][])lists.stream().map(ingredients -> (IIngredient[])ingredients.toArray(IIngredient[]::new)).toArray(x$0 -> new IIngredient[x$0][]), ingredients -> Arrays.stream(ingredients).map(iIngredients -> Arrays.stream(iIngredients).toList()).toList()).forGetter(CTShapedRecipe::getCtIngredients), (App)MirrorAxis.CODEC.fieldOf("mirror_axis").forGetter(CTShapedRecipe::getMirrorAxis)).apply((Applicative)instance, CTShapedRecipe::new));

    private CTShapedRecipeSerializer() {
    }

    public Codec<CTShapedRecipe> m_292673_() {
        return CODEC;
    }

    public CTShapedRecipe fromNetwork(FriendlyByteBuf buffer) {
        int height = buffer.m_130242_();
        int width = buffer.m_130242_();
        IIngredient[][] inputs = new IIngredient[height][width];
        for (int h = 0; h < inputs.length; ++h) {
            for (int w = 0; w < inputs[h].length; ++w) {
                inputs[h][w] = IIngredient.fromIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
        }
        MirrorAxis mirrorAxis = (MirrorAxis)buffer.m_130066_(MirrorAxis.class);
        ItemStack output = buffer.m_130267_();
        return CTShapedRecipeSerializer.makeRecipe(IItemStack.of(output), inputs, mirrorAxis, null);
    }

    public void toNetwork(FriendlyByteBuf buffer, CTShapedRecipe recipe) {
        buffer.m_130130_(recipe.m_44221_());
        buffer.m_130130_(recipe.m_44220_());
        for (Ingredient ingredient : recipe.m_7527_()) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130068_((Enum)recipe.getMirrorAxis());
        buffer.m_130055_(AccessibleElementsProvider.get().registryAccess(recipe::m_8043_));
    }

    private static CTShapedRecipe makeRecipe(IItemStack output, IIngredient[][] ingredients, MirrorAxis mirrorAxis, @Nullable RecipeFunction2D function) {
        return new CTShapedRecipe(output, ingredients, mirrorAxis, function);
    }
}

