/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipeList<T extends Recipe<?>> {
    private final RecipeType<T> recipeType;
    private final Map<ResourceLocation, RecipeHolder<T>> recipes;
    private final Map<ResourceLocation, RecipeHolder<T>> byName;
    private final Map<ResourceLocation, RecipeHolder<T>> unmodifiableRecipes;
    private final Map<ResourceLocation, RecipeHolder<T>> unmodifiableByName;

    public RecipeList(RecipeType<T> recipeType, Map<ResourceLocation, RecipeHolder<T>> recipes, Map<ResourceLocation, RecipeHolder<?>> byName) {
        this.recipeType = recipeType;
        this.recipes = recipes;
        this.byName = (Map)GenericUtil.uncheck(byName);
        this.unmodifiableRecipes = Collections.unmodifiableMap(this.recipes);
        this.unmodifiableByName = Collections.unmodifiableMap(this.byName);
    }

    public List<RecipeHolder<T>> getRecipesByOutput(IIngredient output) {
        return this.getRecipes().values().stream().filter(recipe -> output.matches(IItemStack.ofMutable(AccessibleElementsProvider.get().registryAccess(arg_0 -> ((Recipe)recipe.f_291008_()).m_8043_(arg_0))))).toList();
    }

    public List<RecipeHolder<T>> getRecipesMatching(Predicate<RecipeHolder<T>> predicate) {
        return this.getRecipes().values().stream().filter(predicate).toList();
    }

    public List<RecipeHolder<T>> getAllRecipes() {
        return new ArrayList<RecipeHolder<T>>(this.getRecipes().values());
    }

    public RecipeHolder<T> get(ResourceLocation id) {
        return this.getRecipes().get(id);
    }

    public RecipeHolder<T> get(String id) {
        return this.get(ResourceLocation.m_135820_((String)id));
    }

    public boolean has(ResourceLocation id) {
        return this.getRecipes().containsKey(id);
    }

    public boolean has(String id) {
        return this.has(ResourceLocation.m_135820_((String)id));
    }

    public void add(ResourceLocation id, RecipeHolder<T> recipe) {
        if (this.getByName().containsKey(recipe.f_291676_())) {
            CommonLoggers.api().warn("A recipe with the name '{}' already exists and will be overwritten: this is most likely an error in your scripts", (Object)recipe.f_291676_().m_135815_());
        }
        this.recipes.put(id, recipe);
        this.byName.put(id, recipe);
    }

    public void remove(ResourceLocation id) {
        this.recipes.remove(id);
        this.byName.remove(id);
    }

    public void removeByRecipeTest(Predicate<RecipeHolder<T>> recipePredicate) {
        Iterator<ResourceLocation> iterator = this.recipes.keySet().iterator();
        while (iterator.hasNext()) {
            ResourceLocation next = iterator.next();
            RecipeHolder<T> recipe = this.recipes.get(next);
            if (!recipePredicate.test(recipe)) continue;
            this.byName.remove(next);
            iterator.remove();
        }
    }

    public void removeByIdTest(Predicate<ResourceLocation> idPredicate) {
        this.removeByIdTest(idPredicate, s -> false);
    }

    public void removeByIdTest(Predicate<ResourceLocation> idPredicate, Predicate<String> exclusions) {
        Iterator<ResourceLocation> iterator = this.recipes.keySet().iterator();
        while (iterator.hasNext()) {
            ResourceLocation next = iterator.next();
            if (!idPredicate.test(next) || exclusions.test(next.m_135815_())) continue;
            this.byName.remove(next);
            iterator.remove();
        }
    }

    public void removeAll() {
        this.byName.keySet().removeAll(this.recipes.keySet());
        this.recipes.clear();
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public Map<ResourceLocation, RecipeHolder<T>> getRecipes() {
        return this.unmodifiableRecipes;
    }

    public Map<ResourceLocation, RecipeHolder<T>> getByName() {
        return this.unmodifiableByName;
    }

    public int getSize() {
        return this.getRecipes().size();
    }
}

