/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.item.ActionSetFood;
import com.blamejared.crafttweaker.api.action.item.ActionSetItemProperty;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientPartialTag;
import com.blamejared.crafttweaker.api.item.IItemStackConstants;
import com.blamejared.crafttweaker.api.util.AttributeUtil;
import com.blamejared.crafttweaker.api.util.EnchantmentUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessItem;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IItemStack")
@Document(value="vanilla/api/item/IItemStack")
public interface IItemStack
extends IIngredient,
IIngredientWithAmount {
    public static final Codec<IItemStack> CODEC;
    @ZenCodeType.Field
    public static final String CRAFTTWEAKER_DATA_KEY = "CraftTweakerData";
    @ZenCodeType.Field
    public static final UUID BASE_ATTACK_DAMAGE_UUID;
    @ZenCodeType.Field
    public static final UUID BASE_ATTACK_SPEED_UUID;

    public static IItemStack empty() {
        return IItemStackConstants.EMPTY_STACK.get();
    }

    public static IItemStack of(ItemLike item) {
        return IItemStack.of(new ItemStack(item));
    }

    public static IItemStack of(ItemStack stack) {
        return Services.PLATFORM.createItemStack(stack);
    }

    public static IItemStack of(ItemStack stack, boolean mutable) {
        return mutable ? IItemStack.ofMutable(stack) : IItemStack.of(stack);
    }

    public static IItemStack ofMutable(ItemStack stack) {
        return Services.PLATFORM.createItemStackMutable(stack);
    }

    @ZenCodeType.Method
    public IItemStack copy();

    @ZenCodeType.Getter(value="registryName")
    default public ResourceLocation getRegistryName() {
        return BuiltInRegistries.f_257033_.m_7981_((Object)this.getInternal().m_41720_());
    }

    @ZenCodeType.Getter(value="owner")
    default public String getOwner() {
        return this.getRegistryName().m_135827_();
    }

    @Override
    default public boolean isEmpty() {
        return this.getInternal().m_41619_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="maxStackSize")
    default public int getMaxStackSize() {
        return this.getInternal().m_41720_().m_41459_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="maxStackSize")
    default public void setMaxStackSize(int newMaxStackSize) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Integer>(this, "Max Stack Size", newMaxStackSize, this.getInternal().m_41720_().m_41459_(), ((AccessItem)this.getInternal().m_41720_())::crafttweaker$setMaxStackSize));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="rarity")
    default public Rarity getRarity() {
        return this.getInternal().m_41791_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="rarity")
    default public void setRarity(Rarity newRarity) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Rarity>(this, "Rarity", newRarity, this.getInternal().m_41791_(), ((AccessItem)this.getInternal().m_41720_())::crafttweaker$setRarity));
    }

    @ZenCodeType.Method
    default public IItemStack withLore(Component ... lore) {
        return this.modify(itemStack -> {
            CompoundTag tag = itemStack.m_41698_("display");
            if (lore != null && lore.length != 0) {
                ListTag listtag = new ListTag();
                for (Component component : lore) {
                    listtag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component)));
                }
                tag.m_128365_("Lore", (Tag)listtag);
            } else {
                tag.m_128473_("Lore");
            }
        });
    }

    @ZenCodeType.Getter(value="displayName")
    default public Component getDisplayName() {
        return this.getInternal().m_41611_();
    }

    @ZenCodeType.Method
    default public IItemStack withDisplayName(Component name) {
        return this.modify(itemStack -> itemStack.m_41714_(name));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="hoverName")
    default public Component getHoverName() {
        return this.getInternal().m_41786_();
    }

    @ZenCodeType.Method
    default public void resetHoverName() {
        this.getInternal().m_41787_();
    }

    @ZenCodeType.Getter(value="hasCustomHoverName")
    default public boolean hasDisplayName() {
        return this.getInternal().m_41788_();
    }

    @ZenCodeType.Getter(value="hasFoil")
    default public boolean hasFoil() {
        return this.getInternal().m_41790_();
    }

    @ZenCodeType.Getter(value="isEnchantable")
    default public boolean isEnchantable() {
        return this.getInternal().m_41792_();
    }

    @ZenCodeType.Getter(value="isEnchanted")
    default public boolean isEnchanted() {
        return this.getInternal().m_41793_();
    }

    @ZenCodeType.Getter(value="baseRepairCost")
    default public int getBaseRepairCost() {
        return this.getInternal().m_41610_();
    }

    @Override
    @ZenCodeType.Getter(value="amount")
    default public int getAmount() {
        return this.getInternal().m_41613_();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    default public IItemStack setAmount(int amount) {
        return this.modify(itemStack -> itemStack.m_41764_(amount));
    }

    @ZenCodeType.Method
    default public IItemStack grow(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.setAmount(this.getAmount() + amount);
    }

    @ZenCodeType.Method
    default public IItemStack shrink(@ZenCodeType.OptionalInt(value=1) int amount) {
        return this.setAmount(this.getAmount() - amount);
    }

    @ZenCodeType.Getter(value="stackable")
    default public boolean isStackable() {
        return this.getInternal().m_41753_();
    }

    @ZenCodeType.Method
    default public IItemStack withDamage(int damage) {
        return this.modify(itemStack -> itemStack.m_41721_(damage));
    }

    @ZenCodeType.Method
    default public IItemStack withAttributeModifier(Attribute attribute, String uuid, String name, double value, AttributeModifier.Operation operation, EquipmentSlot[] slotTypes, @ZenCodeType.OptionalBoolean boolean preserveDefaults) {
        return this.withAttributeModifier(attribute, UUID.fromString(uuid), name, value, operation, slotTypes, preserveDefaults);
    }

    @ZenCodeType.Method
    default public IItemStack withAttributeModifier(Attribute attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation, EquipmentSlot[] slotTypes, @ZenCodeType.OptionalBoolean boolean preserveDefaults) {
        return this.modify(itemStack -> {
            for (EquipmentSlot slotType : slotTypes) {
                if (preserveDefaults) {
                    AttributeUtil.addAttributeModifier(itemStack, attribute, new AttributeModifier(uuid, name, value, operation), slotType);
                    continue;
                }
                itemStack.m_41643_(attribute, new AttributeModifier(uuid, name, value, operation), slotType);
            }
        });
    }

    @ZenCodeType.Method
    default public IItemStack withAttributeModifier(Attribute attribute, String name, double value, AttributeModifier.Operation operation, EquipmentSlot[] slotTypes, @ZenCodeType.OptionalBoolean boolean preserveDefaults) {
        return this.modify(itemStack -> {
            for (EquipmentSlot slotType : slotTypes) {
                if (preserveDefaults) {
                    AttributeUtil.addAttributeModifier(itemStack, attribute, new AttributeModifier(name, value, operation), slotType);
                    continue;
                }
                itemStack.m_41643_(attribute, new AttributeModifier(name, value, operation), slotType);
            }
        });
    }

    @ZenCodeType.Method
    default public Map<Attribute, List<AttributeModifier>> getAttributes(EquipmentSlot slotType) {
        return this.getInternal().m_41638_(slotType).asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, attributeAttributeModifierEntry -> new ArrayList((Collection)attributeAttributeModifierEntry.getValue())));
    }

    @ZenCodeType.Getter(value="damageableItem")
    default public boolean isDamageableItem() {
        return this.getInternal().m_41763_();
    }

    @ZenCodeType.Getter(value="damaged")
    default public boolean isDamaged() {
        return this.getInternal().m_41768_();
    }

    @ZenCodeType.Getter(value="maxDamage")
    default public int getMaxDamage() {
        return this.getInternal().m_41776_();
    }

    @ZenCodeType.Setter(value="maxDamage")
    default public void setMaxDamage(int newMaxDamage) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Integer>(this, "Max Damage", newMaxDamage, this.getInternal().m_41776_(), ((AccessItem)this.getInternal().m_41720_())::crafttweaker$setMaxDamage));
    }

    @ZenCodeType.Getter(value="descriptionId")
    default public String getDescriptionId() {
        return this.getInternal().m_41778_();
    }

    @ZenCodeType.Method
    default public IItemStack withTag(MapData tag) {
        return this.modify(itemStack -> itemStack.m_41751_(tag.getInternal()));
    }

    @ZenCodeType.Method
    default public IItemStack withoutTag() {
        return this.modify(itemStack -> itemStack.m_41751_(null));
    }

    @ZenCodeType.Getter(value="hasTag")
    default public boolean hasTag() {
        return this.getInternal().m_41782_();
    }

    @ZenCodeType.Getter(value="tag")
    default public @ZenCodeType.Nullable IData getTag() {
        return TagToDataConverter.convert((Tag)this.getInternal().m_41783_());
    }

    @ZenCodeType.Method
    default public IData getOrCreateTag() {
        if (this.getInternal().m_41783_() == null) {
            this.getInternal().m_41751_(new CompoundTag());
        }
        return this.getTag();
    }

    @Override
    default public boolean matches(IItemStack stack, boolean ignoreDamage) {
        return ItemStackUtil.areStacksTheSame(this.getInternal(), stack.getInternal(), ignoreDamage, true);
    }

    @Override
    default public String getCommandString() {
        return ItemStackUtil.getCommandString(this.getInternal(), this.isMutable());
    }

    @ZenCodeType.Getter(value="useDuration")
    default public int getUseDuration() {
        return this.getInternal().m_41779_();
    }

    @ZenCodeType.Getter(value="useOnRelease")
    default public boolean useOnRelease() {
        return this.getInternal().m_41781_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="food")
    default public @ZenCodeType.Nullable FoodProperties getFood() {
        return this.getInternal().m_41720_().m_41473_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="food")
    default public void setFood(@ZenCodeType.Nullable FoodProperties food) {
        CraftTweakerAPI.apply(new ActionSetFood(this, food, this.getInternal().m_41720_().m_41473_()));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isEdible")
    default public boolean isEdible() {
        return this.getInternal().m_41614_();
    }

    @ZenCodeType.Getter(value="burnTime")
    default public int getBurnTime() {
        return Services.EVENT.getBurnTime(this);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fireResistant")
    default public boolean isFireResistant() {
        return this.getInternal().m_41720_().m_41475_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="fireResistant")
    default public void setFireResistant(boolean fireResistant) {
        CraftTweakerAPI.apply(new ActionSetItemProperty<Boolean>(this, "Fire Resistant", fireResistant, this.getInternal().m_41720_().m_41475_(), ((AccessItem)this.getInternal().m_41720_())::crafttweaker$setFireResistant));
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MOD)
    default public Percentaged<IItemStack> percent(double percentage) {
        return new Percentaged<IItemStack>(this, percentage / 100.0, iItemStack -> iItemStack.getCommandString() + " % " + percentage);
    }

    @ZenCodeType.Caster(implicit=true)
    default public Percentaged<IItemStack> asWeightedItemStack() {
        return this.percent(100.0);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="definition")
    @ZenCodeType.Caster(implicit=true)
    default public Item getDefinition() {
        return this.getInternal().m_41720_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public ItemLike asItemLike() {
        return this.getInternal().m_41720_();
    }

    @ZenCodeType.Method
    public IItemStack asMutable();

    @ZenCodeType.Method
    public IItemStack asImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isMutable")
    default public boolean isMutable() {
        return !this.isImmutable();
    }

    @ZenCodeType.Getter(value="damage")
    default public int getDamage() {
        return this.getInternal().m_41773_();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="enchantments")
    default public Map<Enchantment, Integer> getEnchantments() {
        return EnchantmentHelper.m_44831_((ItemStack)this.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="enchantments")
    default public IItemStack setEnchantments(Map<Enchantment, Integer> enchantments) {
        return this.modify(newStack -> EnchantmentUtil.setEnchantments(enchantments, newStack));
    }

    @ZenCodeType.Method
    default public int getEnchantmentLevel(Enchantment enchantment) {
        return this.getEnchantments().getOrDefault(enchantment, 0);
    }

    @ZenCodeType.Method
    default public IItemStack withEnchantment(Enchantment enchantment, @ZenCodeType.OptionalInt(value=1) int level) {
        return this.modify(itemStack -> {
            Map<Enchantment, Integer> enchantments = this.getEnchantments();
            enchantments.put(enchantment, level);
            EnchantmentUtil.setEnchantments(enchantments, itemStack);
        });
    }

    @ZenCodeType.Method
    default public IItemStack removeEnchantment(Enchantment enchantment) {
        return this.modify(itemStack -> {
            Map<Enchantment, Integer> enchantments = this.getEnchantments();
            enchantments.remove(enchantment);
            EnchantmentUtil.setEnchantments(enchantments, itemStack);
        });
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public ItemStack getInternal();

    @Override
    default public Ingredient asVanillaIngredient() {
        if (this.getInternal().m_41619_()) {
            return Ingredient.f_43901_;
        }
        if (!this.getInternal().m_41782_()) {
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.getImmutableInternal()});
        }
        return IngredientPartialTag.ingredient(this.getImmutableInternal());
    }

    @ZenCodeType.Method
    default public ItemStack getImmutableInternal() {
        return this.getInternal().m_41777_();
    }

    @Override
    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IIngredientWithAmount asIIngredientWithAmount() {
        return this;
    }

    @Override
    default public IItemStack getIngredient() {
        return this;
    }

    @Override
    default public IData asIData() {
        IData data = IIngredient.super.asIData();
        if (!1.$assertionsDisabled && !(data instanceof MapData)) {
            throw new AssertionError();
        }
        data.put("count", new IntData(this.getAmount()));
        return data;
    }

    public IItemStack modify(Consumer<ItemStack> var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("item").forGetter(IItemStack::getInternal), (App)Codec.BOOL.fieldOf("mutable").forGetter(IItemStack::isMutable)).apply((Applicative)instance, IItemStack::of));
        BASE_ATTACK_DAMAGE_UUID = AccessItem.crafttweaker$getBASE_ATTACK_DAMAGE_UUID();
        BASE_ATTACK_SPEED_UUID = AccessItem.crafttweaker$getBASE_ATTACK_SPEED_UUID();
    }
}

