/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.vanilla.type;

import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientPartialTagSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.CraftTweakerVanillaIngredient;
import com.blamejared.crafttweaker.platform.Services;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientPartialTag
implements CraftTweakerVanillaIngredient {
    private final ItemStack stack;

    public static IngredientPartialTag of(ItemStack stack) {
        return new IngredientPartialTag(stack);
    }

    public static Ingredient ingredient(ItemStack children) {
        return Services.PLATFORM.getIngredientPartialTag(children);
    }

    public IngredientPartialTag(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        CompoundTag stack1Tag = this.stack.m_41783_();
        CompoundTag stack2Tag = input.m_41783_();
        if (stack1Tag == null && stack2Tag == null) {
            return true;
        }
        MapData stack2Data = (MapData)TagToDataConverter.convert((Tag)stack2Tag);
        MapData stack1Data = (MapData)TagToDataConverter.convert((Tag)stack1Tag);
        boolean contains = stack1Data == null ? true : stack2Data != null && stack2Data.contains(stack1Data);
        return this.stack.m_41720_() == input.m_41720_() && this.stack.m_41773_() == input.m_41773_() && contains;
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        return List.of(this.stack);
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.m_41619_();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public IngredientPartialTagSerializer serializer() {
        return IngredientPartialTagSerializer.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngredientPartialTag that = (IngredientPartialTag)o;
        return ItemStack.m_41728_((ItemStack)this.getStack(), (ItemStack)that.getStack());
    }

    public int hashCode() {
        return Objects.hash(this.getStack());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IngredientPartialTag{");
        sb.append("stack=").append(this.stack);
        sb.append('}');
        return sb.toString();
    }
}

