/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.vanilla.serializer;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.transform.IIngredientTransformer;
import com.blamejared.crafttweaker.api.ingredient.transform.serializer.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.CraftTweakerVanillaIngredientSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientTransformed;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

@ParametersAreNonnullByDefault
public class IngredientTransformedSerializer
implements CraftTweakerVanillaIngredientSerializer<IngredientTransformed<? extends IIngredient, ? extends IIngredientTransformed<?>>> {
    public static final IngredientTransformedSerializer INSTANCE = new IngredientTransformedSerializer();
    public static final Codec<IngredientTransformed<? extends IIngredient, ? extends IIngredientTransformed<? extends IIngredient>>> CODEC = IIngredientTransformed.CODEC.xmap(IngredientTransformed::of, IngredientTransformed::getCrTIngredient);

    private IngredientTransformedSerializer() {
    }

    @Override
    public Codec<IngredientTransformed<? extends IIngredient, ? extends IIngredientTransformed<? extends IIngredient>>> codec() {
        return CODEC;
    }

    @Override
    public IngredientTransformed<? extends IIngredient, ? extends IIngredientTransformed<?>> decode(FriendlyByteBuf buffer) {
        IIngredient base = IIngredient.fromIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer));
        ResourceLocation type = buffer.m_130281_();
        IIngredientTransformerSerializer value = (IIngredientTransformerSerializer)CraftTweakerRegistries.REGISTRY_TRANSFORMER_SERIALIZER.m_7745_(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return IngredientTransformed.of(new IIngredientTransformed<IIngredient>(base, (IIngredientTransformer)GenericUtil.uncheck(value.fromNetwork(buffer))));
    }

    @Override
    public void encode(FriendlyByteBuf buffer, IngredientTransformed<? extends IIngredient, ? extends IIngredientTransformed<?>> ingredient) {
        Ingredient baseIngredient = ((IIngredientTransformed)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient();
        baseIngredient.m_43923_(buffer);
        IIngredientTransformer<? extends IIngredient> transformer = ingredient.getTransformer();
        IIngredientTransformerSerializer serializer = transformer.getSerializer();
        buffer.m_130085_(serializer.getType());
        serializer.toNetwork(buffer, (IIngredientTransformer)GenericUtil.uncheck(transformer));
    }

    @Override
    public ResourceLocation getId() {
        return IIngredientTransformed.ID;
    }
}

