/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.vanilla.serializer;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.ingredient.condition.serializer.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.CraftTweakerVanillaIngredientSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientCraftTweaker;
import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

@ParametersAreNonnullByDefault
public class IngredientConditionedSerializer
implements CraftTweakerVanillaIngredientSerializer<IngredientConditioned<? extends IIngredient, ? extends IIngredientConditioned<?>>> {
    public static final IngredientConditionedSerializer INSTANCE = new IngredientConditionedSerializer();
    public static final Codec<IngredientConditioned<? extends IIngredient, ? extends IIngredientConditioned<? extends IIngredient>>> CODEC = IIngredientConditioned.CODEC.xmap(IngredientConditioned::of, IngredientCraftTweaker::getCrTIngredient);

    private IngredientConditionedSerializer() {
    }

    @Override
    public ResourceLocation getId() {
        return IIngredientConditioned.ID;
    }

    @Override
    public Codec<IngredientConditioned<? extends IIngredient, ? extends IIngredientConditioned<? extends IIngredient>>> codec() {
        return CODEC;
    }

    @Override
    public IngredientConditioned<? extends IIngredient, ? extends IIngredientConditioned<?>> decode(FriendlyByteBuf buffer) {
        IIngredient base = IIngredient.fromIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer));
        ResourceLocation type = buffer.m_130281_();
        IIngredientConditionSerializer value = (IIngredientConditionSerializer)CraftTweakerRegistries.REGISTRY_CONDITIONER_SERIALIZER.m_7745_(type);
        if (value == null) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        return IngredientConditioned.of(new IIngredientConditioned<IIngredient>(base, (IIngredientCondition<IIngredient>)value.fromNetwork(buffer)));
    }

    @Override
    public void encode(FriendlyByteBuf buffer, IngredientConditioned<? extends IIngredient, ? extends IIngredientConditioned<?>> ingredient) {
        Ingredient baseIngredient = ((IIngredientConditioned)ingredient.getCrTIngredient()).getBaseIngredient().asVanillaIngredient();
        baseIngredient.m_43923_(buffer);
        IIngredientCondition<? extends IIngredient> condition = ingredient.getCondition();
        IIngredientConditionSerializer serializer = condition.getSerializer();
        buffer.m_130085_(serializer.getType());
        condition.write(buffer);
    }
}

