/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.vanilla;

import com.blamejared.crafttweaker.api.ingredient.vanilla.CraftTweakerIngredients;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.CraftTweakerVanillaIngredient;
import java.util.Objects;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;

@MethodsReturnNonnullByDefault
class DelegatingCustomIngredient<T extends CraftTweakerVanillaIngredient>
extends AbstractIngredient {
    private final T internal;

    DelegatingCustomIngredient(T internal) {
        this.internal = internal;
    }

    public boolean test(ItemStack stack) {
        return this.internal.test(stack);
    }

    public ItemStack[] m_43908_() {
        return (ItemStack[])this.internal.getMatchingStacks().toArray(ItemStack[]::new);
    }

    public boolean isSimple() {
        return !this.internal.requiresTesting();
    }

    public boolean m_43947_() {
        return this.internal.isEmpty();
    }

    public IIngredientSerializer<? extends Ingredient> serializer() {
        return CraftTweakerIngredients.Serializers.of(this.internal.serializer());
    }

    public T internal() {
        return this.internal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DelegatingCustomIngredient that = (DelegatingCustomIngredient)((Object)o);
        return Objects.equals(this.internal, that.internal);
    }

    public int hashCode() {
        return Objects.hash(this.internal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DelegatingCustomIngredient{");
        sb.append("internal=").append(this.internal);
        sb.append('}');
        return sb.toString();
    }
}

