/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientTransformed;
import com.blamejared.crafttweaker.api.ingredient.vanilla.DelegatingCustomIngredient;
import com.blamejared.crafttweaker.api.ingredient.vanilla.DelegatingCustomIngredientSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.CraftTweakerVanillaIngredientSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientAnySerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientConditionedSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientListSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientPartialTagSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.serializer.IngredientTransformedSerializer;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.CraftTweakerVanillaIngredient;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientAny;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientConditioned;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientList;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientPartialTag;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientTransformed;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;

public class CraftTweakerIngredients {
    private static final BiMap<CraftTweakerVanillaIngredientSerializer<?>, DelegatingCustomIngredientSerializer<?>> SERIALIZER_CACHE = HashBiMap.create();
    private static final BiMap<CraftTweakerVanillaIngredient, DelegatingCustomIngredient<?>> SINGLETON_CACHE = HashBiMap.create();

    public static class Serializers {
        public static final IIngredientSerializer<?> ANY = (IIngredientSerializer)SERIALIZER_CACHE.computeIfAbsent((Object)IngredientAnySerializer.INSTANCE, DelegatingCustomIngredientSerializer::new);
        public static final IIngredientSerializer<?> CONDITIONED = (IIngredientSerializer)SERIALIZER_CACHE.computeIfAbsent((Object)IngredientConditionedSerializer.INSTANCE, DelegatingCustomIngredientSerializer::new);
        public static final IIngredientSerializer<?> TRANSFORMED = (IIngredientSerializer)SERIALIZER_CACHE.computeIfAbsent((Object)IngredientTransformedSerializer.INSTANCE, DelegatingCustomIngredientSerializer::new);
        public static final IIngredientSerializer<?> LIST = (IIngredientSerializer)SERIALIZER_CACHE.computeIfAbsent((Object)IngredientListSerializer.INSTANCE, DelegatingCustomIngredientSerializer::new);
        public static final IIngredientSerializer<?> PARTIAL_TAG = (IIngredientSerializer)SERIALIZER_CACHE.computeIfAbsent((Object)IngredientPartialTagSerializer.INSTANCE, DelegatingCustomIngredientSerializer::new);

        static <T extends CraftTweakerVanillaIngredient> IIngredientSerializer<DelegatingCustomIngredient<T>> of(CraftTweakerVanillaIngredientSerializer<T> ingredient) {
            return (IIngredientSerializer)GenericUtil.uncheck(SERIALIZER_CACHE.computeIfAbsent(ingredient, DelegatingCustomIngredientSerializer::new));
        }
    }

    public static class Ingredients {
        public static Ingredient any() {
            return (Ingredient)SINGLETON_CACHE.computeIfAbsent((Object)IngredientAny.of(), DelegatingCustomIngredient::new);
        }

        public static <I extends IIngredient, T extends IIngredientConditioned<I>> Ingredient conditioned(T condition) {
            return new DelegatingCustomIngredient(IngredientConditioned.of(condition));
        }

        public static <I extends IIngredient, T extends IIngredientTransformed<I>> Ingredient transformed(T transformed) {
            return new DelegatingCustomIngredient(IngredientTransformed.of(transformed));
        }

        public static Ingredient list(List<Ingredient> children) {
            return new DelegatingCustomIngredient<IngredientList>(IngredientList.of(children));
        }

        public static Ingredient partialTag(ItemStack stack) {
            return new DelegatingCustomIngredient<IngredientPartialTag>(new IngredientPartialTag(stack));
        }

        static <T extends CraftTweakerVanillaIngredient> DelegatingCustomIngredient<T> of(T ingredient) {
            if (ingredient.singleton()) {
                return (DelegatingCustomIngredient)((Object)GenericUtil.uncheck(SINGLETON_CACHE.computeIfAbsent(ingredient, DelegatingCustomIngredient::new)));
            }
            return new DelegatingCustomIngredient<T>(ingredient);
        }
    }
}

