/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.type;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.condition.IIngredientCondition;
import com.blamejared.crafttweaker.api.ingredient.vanilla.type.IngredientConditioned;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ingredient.type.IngredientConditioned")
@Document(value="vanilla/api/ingredient/type/IngredientConditioned")
public class IIngredientConditioned<T extends IIngredient>
implements IIngredient {
    public static final ResourceLocation ID = CraftTweakerConstants.rl("conditioned");
    public static final Codec<IIngredientConditioned<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IIngredient.CODEC.fieldOf("base").forGetter(IIngredientConditioned::getBaseIngredient), (App)IIngredientCondition.CODEC.fieldOf("condition").forGetter(IIngredientConditioned::getCondition)).apply((Applicative)instance, (base, condition) -> new IIngredientConditioned<IIngredient>((IIngredient)base, (IIngredientCondition)GenericUtil.uncheck(condition))));
    private final T base;
    private final IIngredientCondition<T> condition;

    public IIngredientConditioned(T base, IIngredientCondition<T> condition) {
        this.base = base;
        this.condition = condition;
    }

    @Override
    public Ingredient asVanillaIngredient() {
        return IngredientConditioned.ingredient(this);
    }

    @ZenCodeType.Getter(value="condition")
    public IIngredientCondition<T> getCondition() {
        return this.condition;
    }

    @Override
    public String getCommandString() {
        return this.condition.getCommandString(this.base);
    }

    @ZenCodeType.Getter(value="baseIngredient")
    public T getBaseIngredient() {
        return this.base;
    }

    @Override
    @ZenCodeType.Method
    public boolean matches(IItemStack stack, boolean ignoreDamage) {
        return this.base.matches(stack, this.condition.ignoresDamage()) && this.condition.matches(stack);
    }

    @Override
    @ZenCodeType.Getter(value="items")
    public IItemStack[] getItems() {
        return this.base.getItems();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IIngredientConditioned that = (IIngredientConditioned)o;
        if (!this.base.equals(that.base)) {
            return false;
        }
        return this.condition.equals(that.condition);
    }

    public int hashCode() {
        int result = this.base.hashCode();
        result = 31 * result + this.condition.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IIngredientConditioned{");
        sb.append("base=").append(this.base);
        sb.append(", condition=").append(this.condition);
        sb.append('}');
        return sb.toString();
    }
}

