/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data.op;

import com.blamejared.crafttweaker.api.data.ByteArrayData;
import com.blamejared.crafttweaker.api.data.EmptyData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.IntArrayData;
import com.blamejared.crafttweaker.api.data.ListData;
import com.blamejared.crafttweaker.api.data.LongArrayData;
import com.blamejared.crafttweaker.api.data.op.AnyTypeListDataAdapter;
import com.blamejared.crafttweaker.api.data.op.ListDataAdapter;
import com.blamejared.crafttweaker.api.data.op.SameTypeListDataAdapter;

final class DecidingListDataAdapter
implements ListDataAdapter {
    private DecidingListDataAdapter() {
    }

    public static DecidingListDataAdapter of() {
        return new DecidingListDataAdapter();
    }

    @Override
    public IData finish() {
        return EmptyData.INSTANCE;
    }

    @Override
    public ListDataAdapter apply(IData data) {
        return switch (data.getType()) {
            case IData.Type.BYTE -> SameTypeListDataAdapter.element(data, () -> new ByteArrayData(new byte[0]));
            case IData.Type.INT -> SameTypeListDataAdapter.element(data, () -> new IntArrayData(new int[0]));
            case IData.Type.LONG -> SameTypeListDataAdapter.element(data, () -> new LongArrayData(new long[0]));
            case IData.Type.MAP -> AnyTypeListDataAdapter.element(data);
            case IData.Type.EMPTY -> this;
            default -> SameTypeListDataAdapter.element(data, ListData::new);
        };
    }

    public String toString() {
        return "ListDataAdapter[NONE/%s]".formatted(this.finish());
    }
}

