/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.command;

import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.impl.network.message.MessageCopy;
import com.blamejared.crafttweaker.platform.Services;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.Logger;

public final class CommandUtilities {
    public static final Logger COMMAND_LOGGER = CommonLoggers.commands();

    private CommandUtilities() {
    }

    public static void sendCopyingAndCopy(CommandSourceStack source, MutableComponent component, String toCopy) {
        CommandUtilities.sendCopying(source, component, toCopy);
        CommandUtilities.copy(source, toCopy);
    }

    public static void sendCopying(CommandSourceStack source, MutableComponent component, String toCopy) {
        CommandUtilities.send(source, CommandUtilities.copy(component, toCopy));
    }

    public static void send(CommandSourceStack source, Component component) {
        source.m_288197_(() -> component, true);
        if (!component.getString().isBlank()) {
            COMMAND_LOGGER.info(component.getString());
        }
    }

    public static void copy(CommandSourceStack source, String toCopy) {
        if (source.m_230897_()) {
            Services.NETWORK.sendCopyMessage(source.m_230896_(), new MessageCopy(toCopy));
        }
    }

    public static void open(CommandSourceStack source, Path path) {
        MutableComponent component = Component.m_237110_((String)"crafttweaker.command.click.open", (Object[])new Object[]{Component.m_237113_((String)path.toString()).m_130940_(ChatFormatting.GOLD)});
        CommandUtilities.send(source, (Component)component.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component.m_6881_())).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path.toString()))));
    }

    public static Component copy(MutableComponent base, String toCopy) {
        Style style = base.m_7383_();
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"crafttweaker.command.click.copy", (Object[])new Object[]{Component.m_237113_((String)toCopy).m_130940_(ChatFormatting.GOLD)})));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, toCopy));
        return base.m_6270_(style);
    }

    public static Component open(MutableComponent base, String path) {
        Style style = base.m_7383_();
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"crafttweaker.command.click.open", (Object[])new Object[]{Component.m_237113_((String)path).m_130940_(ChatFormatting.GOLD)})));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path));
        return base.m_6270_(style);
    }

    public static Component run(MutableComponent base, String command) {
        Style style = base.m_7383_();
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237110_((String)"crafttweaker.command.click.run", (Object[])new Object[]{Component.m_237113_((String)command).m_130940_(ChatFormatting.GOLD)})));
        style = style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        return base.m_6270_(style);
    }

    public static Component openingUrl(MutableComponent base, String url) {
        MutableComponent component = Component.m_237110_((String)"crafttweaker.command.click.goto", (Object[])new Object[]{Component.m_237113_((String)url).m_130940_(ChatFormatting.GOLD)});
        return base.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url)));
    }

    public static Component openingFile(MutableComponent base, String path) {
        MutableComponent component = Component.m_237110_((String)"crafttweaker.command.click.open", (Object[])new Object[]{Component.m_237113_((String)path).m_130940_(ChatFormatting.GOLD)});
        return base.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)component)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, path)));
    }

    public static Component openingLogFile(MutableComponent base) {
        return CommandUtilities.openingFile(base, "logs/crafttweaker.log");
    }

    public static MutableComponent getFormattedLogFile() {
        return Component.m_237113_((String)"logs/crafttweaker.log").m_130940_(ChatFormatting.AQUA);
    }

    public static MutableComponent makeNoticeable(MutableComponent text) {
        return text.m_130940_(ChatFormatting.YELLOW);
    }

    public static MutableComponent makeNoticeable(String text) {
        return CommandUtilities.makeNoticeable(Component.m_237113_((String)text));
    }
}

