/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket;

import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logging.CommonLoggers;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.ITargetingStrategy;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.bracket.BracketHandlers")
@Document(value="vanilla/api/BracketHandlers")
public class BracketHandlers {
    public static <T> T getRegistry(String tokens, Registry<T> registry) {
        return BracketHandlers.getRegistry(tokens, registry, false);
    }

    public static <T> T getRegistry(String tokens, Registry<T> registry, boolean includeTypeNamespace) {
        String[] split;
        String type;
        String string = type = includeTypeNamespace ? registry.m_123023_().m_135782_().toString() : registry.m_123023_().m_135782_().m_135815_();
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("{} bracket <{}:{}> is not lowercase!", (Object)type, (Object)type, (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get " + type + " with name: <" + type + ":" + tokens + ">! Syntax is <" + type + ":modid:name>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        return registry.m_6612_(key).orElseThrow(() -> new IllegalArgumentException("Could not get " + type + " with name: <" + type + ":" + tokens + ">! " + type + " does not exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="attribute")
    public static Attribute getAttribute(String tokens) {
        return (Attribute)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_256951_);
    }

    @ZenCodeType.Method
    @BracketResolver(value="block")
    public static Block getBlock(String tokens) {
        return (Block)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_256975_);
    }

    @ZenCodeType.Method
    @BracketResolver(value="fluid")
    public static IFluidStack getFluidStack(String tokens) {
        return IFluidStack.of((Fluid)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_257020_), 1L);
    }

    @ZenCodeType.Method
    @BracketResolver(value="blockstate")
    public static BlockState getBlockState(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("BlockState bracket <blockstate:{}> is not lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":", 4)).length > 1) {
            String blockName = split[0] + ":" + split[1];
            String properties = split.length > 2 ? split[2] : "";
            Optional found = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(blockName));
            if (found.isEmpty()) {
                IllegalArgumentException t = new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">! The block does not exist!");
                CommonLoggers.zenCode().error("Error creating BlockState!", (Throwable)t);
            } else {
                return BracketHandlers.getBlockState((Block)found.get(), blockName, properties);
            }
        }
        CommonLoggers.zenCode().error("Error creating BlockState!", (Throwable)new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">!"));
        return null;
    }

    public static BlockState getBlockState(String name, String properties) {
        return BracketHandlers.getBlockState((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(name)), name, properties);
    }

    public static BlockState getBlockState(Block block, String name, String properties) {
        BlockState blockState = block.m_49966_();
        if (properties != null && !properties.isEmpty()) {
            for (String propertyPair : properties.split(",")) {
                String[] splitPair = propertyPair.split("=");
                if (splitPair.length != 2) {
                    CommonLoggers.zenCode().warn("Invalid blockstate property format '{}'. Using default property value.", (Object)propertyPair);
                    continue;
                }
                blockState = ExpandBlockState.withProperty(blockState, splitPair[0], splitPair[1]);
            }
        }
        return blockState;
    }

    @BracketResolver(value="mobeffect")
    @ZenCodeType.Method
    public static MobEffect getMobEffect(String tokens) {
        return (MobEffect)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_256974_);
    }

    @ZenCodeType.Method
    @BracketResolver(value="enchantment")
    public static Enchantment getEnchantment(String tokens) {
        return (Enchantment)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_256876_);
    }

    @ZenCodeType.Method
    @BracketResolver(value="entitytype")
    public static EntityType<Entity> getEntityType(String tokens) {
        return (EntityType)GenericUtil.uncheck(BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_256780_));
    }

    @BracketResolver(value="item")
    @ZenCodeType.Method
    public static IItemStack getItem(String tokens) {
        return IItemStack.of(new ItemStack((ItemLike)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_257033_)));
    }

    @BracketResolver(value="potion")
    @ZenCodeType.Method
    public static Potion getPotion(String tokens) {
        return (Potion)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_256980_);
    }

    @ZenCodeType.Method
    public static IRecipeManager<?> getRecipeManager(String tokens) {
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("RecipeType bracket <recipetype:{}> is not lower-cased!", (Object)tokens);
        }
        if (tokens.equalsIgnoreCase("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Nice try, but there's no reason you need to access the <recipetype:crafttweaker:scripts> recipe manager!");
        }
        ResourceLocation key = new ResourceLocation(tokens);
        IRecipeManager<Recipe<?>> result = RecipeTypeBracketHandler.getOrDefault(key);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Could not get RecipeType with name: <recipetype:" + tokens + ">! RecipeType does not exist!");
    }

    @ZenCodeType.Method
    @BracketResolver(value="profession")
    public static VillagerProfession getProfession(String tokens) {
        return (VillagerProfession)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_256735_);
    }

    @ZenCodeType.Method
    @BracketResolver(value="soundevent")
    public static SoundEvent getSoundEvent(String tokens) {
        return (SoundEvent)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_256894_);
    }

    @ZenCodeType.Method
    @BracketResolver(value="targetingstrategy")
    public static ITargetingStrategy getTargetingStrategy(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CommonLoggers.zenCode().warn("Targeting strategy bracket <targetingstrategy:{}> is not lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get targeting strategy with <targetingstrategy:" + tokens + ">: syntax is <targetingstrategy:modid:name>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        return ITargetingStrategy.find(key);
    }

    @ZenCodeType.Method
    @BracketResolver(value="villagertype")
    public static VillagerType getVillagerType(String tokens) {
        return (VillagerType)BracketHandlers.getRegistry(tokens, BuiltInRegistries.f_256934_);
    }
}

