/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.recipe.replace;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.action.internal.CraftTweakerAction;
import com.blamejared.crafttweaker.api.action.recipe.replace.ActionReplaceRecipe;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.GenericRecipesManager;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.IFilteringRule;
import com.blamejared.crafttweaker.api.recipe.replacement.IReplacerRegistry;
import com.blamejared.crafttweaker.api.recipe.replacement.ReplacementRequest;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import java.util.Collection;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public final class ActionBatchReplacement
extends CraftTweakerAction
implements IRuntimeAction {
    private final Collection<IFilteringRule> targetingRules;
    private final Collection<ReplacementRequest<?>> requests;
    private final IReplacerRegistry registry;

    private ActionBatchReplacement(Collection<IFilteringRule> targetingRules, Collection<ReplacementRequest<?>> requests) {
        this.targetingRules = targetingRules;
        this.requests = requests;
        this.registry = CraftTweakerAPI.getRegistry().getReplacerRegistry();
    }

    public static ActionBatchReplacement of(Collection<IFilteringRule> targetingRules, Collection<ReplacementRequest<?>> requests) {
        return new ActionBatchReplacement(targetingRules, requests);
    }

    @Override
    public void apply() {
        this.castFilters(GenericRecipesManager.INSTANCE.getAllRecipesRaw().stream()).forEach(this::replace);
    }

    @Override
    public String describe() {
        Collector<CharSequence, ?, String> joiner = Collectors.joining(",", "{", "}");
        return "Replacing in %s according to requests %s".formatted(this.targetingRules.isEmpty() ? "everything" : this.targetingRules.stream().map(IFilteringRule::describe).collect(joiner), this.requests.stream().map(ReplacementRequest::describe).collect(joiner));
    }

    private Stream<RecipeHolder<?>> castFilters(Stream<RecipeHolder<?>> recipeStream) {
        return Stream.concat(this.registry.filters().stream(), this.targetingRules.stream()).reduce((a, b) -> it -> b.castFilter(a.castFilter(it))).map(it -> it.castFilter(recipeStream)).orElse(recipeStream);
    }

    private <C extends Container, T extends Recipe<C>> void replace(RecipeHolder<?> recipe) {
        RecipeHolder typedRecipe = (RecipeHolder)GenericUtil.uncheck(recipe);
        IRecipeHandler<Recipe> handler = CraftTweakerAPI.getRegistry().getRecipeHandlerFor(typedRecipe);
        IRecipeManager<Recipe<?>> manager = RecipeTypeBracketHandler.getOrDefault(recipe.f_291008_().m_6671_());
        handler.decompose(manager, AccessibleElementsProvider.get().registryAccess(), typedRecipe.f_291008_()).ifPresent(it -> this.replace((IRecipeManager)manager, handler, typedRecipe.f_291676_(), (IDecomposedRecipe)it));
    }

    private <C extends Container, T extends Recipe<C>> void replace(IRecipeManager<? super T> manager, IRecipeHandler<T> handler, ResourceLocation name, IDecomposedRecipe recipe) {
        if (this.apply(recipe)) {
            CraftTweakerAPI.apply(new ActionReplaceRecipe<T>(name, manager, newName -> (RecipeHolder)GenericUtil.uncheck(this.rebuild(recipe, manager, handler, (ResourceLocation)newName))));
        }
    }

    private boolean apply(IDecomposedRecipe recipe) {
        boolean any = false;
        for (ReplacementRequest<?> request : this.requests) {
            any |= request.applyRequest(recipe);
        }
        return any;
    }

    private <C extends Container, T extends Recipe<C>> RecipeHolder<T> rebuild(IDecomposedRecipe recipe, IRecipeManager<? super T> manager, IRecipeHandler<T> handler, ResourceLocation newName) {
        return handler.recompose(manager, AccessibleElementsProvider.get().registryAccess(), recipe).map(it -> new RecipeHolder(newName, it)).orElseThrow(() -> new IllegalStateException("Recomposition failed due to an error"));
    }
}

