/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class NetworkManager {
    protected final SimpleChannel channel;

    public NetworkManager(ResourceLocation name, int version) {
        if (name == null || version < 0) {
            throw new IllegalArgumentException();
        }
        this.channel = ChannelBuilder.named((ResourceLocation)name).networkProtocolVersion(version).acceptedVersions(Channel.VersionTest.exact((int)version)).simpleChannel();
    }

    public <T extends NetworkPacket> void registerPacket(int discriminator, Class<T> packetClass, Supplier<T> packetSupplier) {
        if (packetClass == null || packetSupplier == null || packetSupplier.get() == null) {
            throw new IllegalArgumentException();
        }
        this.channel.messageBuilder(packetClass, discriminator).decoder(b -> {
            NetworkPacket p = (NetworkPacket)packetSupplier.get();
            p.readFromBuffer((FriendlyByteBuf)b);
            return p;
        }).encoder((p, b) -> p.writeToBuffer((FriendlyByteBuf)b)).consumerNetworkThread((p, c) -> {
            switch (c.getDirection().getReceptionSide()) {
                case CLIENT: {
                    p.handlePacketClient((CustomPayloadEvent.Context)c);
                    c.setPacketHandled(true);
                    break;
                }
                case SERVER: {
                    p.handlePacketServer((CustomPayloadEvent.Context)c);
                    c.setPacketHandled(true);
                    break;
                }
            }
        }).add();
    }

    public <T extends NetworkPacket> void send(T packet, PacketDistributor.PacketTarget target) {
        if (packet == null || target == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(packet, target);
    }

    public <T extends NetworkPacket> void sendTo(T packet, ServerPlayer player) {
        if (packet == null || player == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(packet, PacketDistributor.PLAYER.with((Object)player));
    }

    public <T extends NetworkPacket> void sendToAll(T packet) {
        if (packet == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(packet, PacketDistributor.ALL.noArg());
    }

    public <T extends NetworkPacket> void sendToAllAround(T packet, PacketDistributor.TargetPoint point) {
        if (packet == null || point == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(packet, PacketDistributor.NEAR.with((Object)point));
    }

    public <T extends NetworkPacket> void sendToDimension(T packet, ResourceKey<Level> dimension) {
        if (packet == null || dimension == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(packet, PacketDistributor.DIMENSION.with(dimension));
    }

    public <T extends NetworkPacket> void sendToServer(T packet) {
        if (packet == null) {
            throw new IllegalArgumentException();
        }
        this.channel.send(packet, PacketDistributor.SERVER.noArg());
    }

    public static interface NetworkPacket {
        public void handlePacketClient(CustomPayloadEvent.Context var1);

        public void handlePacketServer(CustomPayloadEvent.Context var1);

        public void readFromBuffer(FriendlyByteBuf var1);

        public void writeToBuffer(FriendlyByteBuf var1);
    }
}

