/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import lain.mods.cos.api.event.CosArmorDeathDrops;
import lain.mods.cos.impl.ModConfigs;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.ContainerCosArmor;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import lain.mods.cos.impl.network.packet.PacketSyncCosArmor;
import lain.mods.cos.impl.network.packet.PacketSyncHiddenFlags;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.server.ServerLifecycleHooks;

public class InventoryManager {
    protected static final InventoryCosArmor Dummy = new InventoryCosArmor(){

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Override
        public boolean isHidden(String modid, String identifier) {
            return false;
        }

        @Override
        public boolean isSkinArmor(int slot) {
            return false;
        }

        @Override
        protected void onContentsChanged(int slot) {
        }

        @Override
        protected void onLoad() {
        }

        @Override
        public boolean setHidden(String modid, String identifier, boolean set) {
            return false;
        }

        @Override
        public void setSkinArmor(int slot, boolean enabled) {
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }

        @Override
        public boolean setUpdateListener(InventoryCosArmor.ContentsChangeListener listener) {
            return false;
        }

        @Override
        public boolean setUpdateListener(InventoryCosArmor.HiddenFlagsChangeListener listener) {
            return false;
        }
    };
    protected static final Random RANDOM = new Random();
    protected final LoadingCache<UUID, InventoryCosArmor> CommonCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<UUID, InventoryCosArmor>(){

        public InventoryCosArmor load(UUID key) throws Exception {
            InventoryCosArmor inventory = new InventoryCosArmor();
            inventory.setUpdateListener((inv, slot) -> InventoryManager.this.onInventoryChanged(key, inv, slot));
            inventory.setUpdateListener((inv, modid, identifier) -> InventoryManager.this.onHiddenFlagsChanged(key, inv, modid, identifier));
            InventoryManager.this.loadInventory(key, inventory);
            return inventory;
        }
    });

    public static boolean checkIdentifier(String modid, String identifier) {
        if (modid == null || modid.isEmpty() || identifier == null || identifier.isEmpty() || !ModList.get().isLoaded(modid)) {
            return false;
        }
        return false;
    }

    public ContainerCosArmor createContainerClient(int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public InventoryCosArmor getCosArmorInventory(UUID uuid) {
        if (uuid == null) {
            return Dummy;
        }
        return (InventoryCosArmor)((Object)this.CommonCache.getUnchecked((Object)uuid));
    }

    @Nonnull
    public InventoryCosArmor getCosArmorInventoryClient(UUID uuid) {
        throw new UnsupportedOperationException();
    }

    protected File getDataFile(UUID uuid) {
        return new File(ServerLifecycleHooks.getCurrentServer().m_129843_(LevelResource.f_78176_).toFile(), uuid + ".cosarmor");
    }

    private void handlePlayerDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof Player && event.getEntity().m_21515_() && !event.getEntity().m_20193_().m_46469_().m_46207_(GameRules.f_46133_) && !((Boolean)ModConfigs.CosArmorKeepThroughDeath.get()).booleanValue()) {
            InventoryCosArmor inv = this.getCosArmorInventory(event.getEntity().m_20148_());
            if (MinecraftForge.EVENT_BUS.post((Event)new CosArmorDeathDrops((Player)event.getEntity(), inv))) {
                return;
            }
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i).m_41777_();
                if (stack.m_41619_()) continue;
                float fX = RANDOM.nextFloat() * 0.75f + 0.125f;
                float fY = RANDOM.nextFloat() * 0.75f;
                float fZ = RANDOM.nextFloat() * 0.75f + 0.125f;
                while (!stack.m_41619_()) {
                    ItemEntity entity = new ItemEntity(event.getEntity().m_20193_(), event.getEntity().m_20185_() + (double)fX, event.getEntity().m_20186_() + (double)fY, event.getEntity().m_20189_() + (double)fZ, stack.m_41620_(RANDOM.nextInt(21) + 10));
                    entity.m_20334_(RANDOM.nextGaussian() * (double)0.05f, RANDOM.nextGaussian() * (double)0.05f + (double)0.2f, RANDOM.nextGaussian() * (double)0.05f);
                    event.getDrops().add(entity);
                }
                inv.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
    }

    private void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        this.CommonCache.invalidate((Object)event.getEntity().m_20148_());
        this.getCosArmorInventory(event.getEntity().m_20148_());
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            for (ServerPlayer other : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                if (other == player) continue;
                UUID uuid = other.m_20148_();
                InventoryCosArmor inv = this.getCosArmorInventory(uuid);
                for (int i = 0; i < inv.getSlots(); ++i) {
                    ModObjects.network.sendTo(new PacketSyncCosArmor(uuid, inv, i), player);
                }
                inv.forEachHidden((modid, identifier) -> ModObjects.network.sendTo(new PacketSyncHiddenFlags(uuid, inv, (String)modid, (String)identifier), player));
            }
        }
    }

    private void handlePlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID uuid = event.getEntity().m_20148_();
        InventoryCosArmor inv = (InventoryCosArmor)((Object)this.CommonCache.getIfPresent((Object)uuid));
        if (inv != null) {
            this.saveInventory(uuid, inv);
            this.CommonCache.invalidate((Object)uuid);
        }
    }

    private void handleRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clearcosarmor").requires(s -> s.m_6761_(2))).executes(s -> {
            int count = 0;
            ServerPlayer player = ((CommandSourceStack)s.getSource()).m_81375_();
            InventoryCosArmor inv = this.getCosArmorInventory(player.m_20148_());
            for (int i = 0; i < inv.getSlots(); ++i) {
                count += inv.extractItem(i, Integer.MAX_VALUE, false).m_41613_();
            }
            int result = count;
            ((CommandSourceStack)s.getSource()).m_288197_(() -> Component.m_237110_((String)"cos.command.clearcosarmor.success.single", (Object[])new Object[]{result, player.m_5446_()}), true);
            return result;
        })).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(s -> {
            int count = 0;
            Collection players = EntityArgument.m_91477_((CommandContext)s, (String)"targets");
            for (ServerPlayer player : players) {
                InventoryCosArmor inv = this.getCosArmorInventory(player.m_20148_());
                for (int i = 0; i < inv.getSlots(); ++i) {
                    count += inv.extractItem(i, Integer.MAX_VALUE, false).m_41613_();
                }
            }
            int result = count;
            if (players.size() == 1) {
                ((CommandSourceStack)s.getSource()).m_288197_(() -> Component.m_237110_((String)"cos.command.clearcosarmor.success.single", (Object[])new Object[]{result, ((ServerPlayer)players.iterator().next()).m_5446_()}), true);
            } else {
                ((CommandSourceStack)s.getSource()).m_288197_(() -> Component.m_237110_((String)"cos.command.clearcosarmor.success.multiple", (Object[])new Object[]{result, players.size()}), true);
            }
            return result;
        })));
        if (!((Boolean)ModConfigs.CosArmorDisableCosHatCommand.get()).booleanValue()) {
            event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"coshat").requires(s -> s.m_6761_(0))).executes(s -> {
                ServerPlayer player = ((CommandSourceStack)s.getSource()).m_81375_();
                InventoryCosArmor inv = this.getCosArmorInventory(player.m_20148_());
                ItemStack stack1 = player.m_6844_(EquipmentSlot.MAINHAND);
                ItemStack stack2 = inv.getStackInSlot(3);
                player.m_8061_(EquipmentSlot.MAINHAND, stack2);
                inv.setStackInSlot(3, stack1);
                return 0;
            }));
        }
    }

    private void handleSaveToFile(PlayerEvent.SaveToFile event) {
        UUID uuid = UUID.fromString(event.getPlayerUUID());
        InventoryCosArmor inv = (InventoryCosArmor)((Object)this.CommonCache.getIfPresent((Object)uuid));
        if (inv != null) {
            this.saveInventory(uuid, inv);
        }
    }

    private void handleServerStopping(ServerStoppingEvent event) {
        ModObjects.logger.debug("Server is stopping... try to save all still loaded CosmeticArmor data");
        this.CommonCache.asMap().entrySet().forEach(e -> {
            ModObjects.logger.debug(e.getKey());
            this.saveInventory((UUID)e.getKey(), (InventoryCosArmor)((Object)((Object)e.getValue())));
        });
        this.CommonCache.invalidateAll();
    }

    protected void loadInventory(UUID uuid, InventoryCosArmor inventory) {
        if (inventory == Dummy) {
            return;
        }
        try {
            File file = this.getDataFile(uuid);
            if (file.exists()) {
                inventory.deserializeNBT(NbtIo.m_128953_((Path)file.toPath()));
            }
        }
        catch (Throwable t) {
            ModObjects.logger.fatal("Failed to load CosmeticArmor data", t);
        }
    }

    protected void onHiddenFlagsChanged(UUID uuid, InventoryCosArmor inventory, String modid, String identifier) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_6982_()) {
            ModObjects.network.sendToAll(new PacketSyncHiddenFlags(uuid, inventory, modid, identifier));
        } else {
            server.m_6846_().m_11314_().forEach(player -> ModObjects.network.sendTo(new PacketSyncHiddenFlags(uuid, inventory, modid, identifier), (ServerPlayer)player));
        }
    }

    protected void onInventoryChanged(UUID uuid, InventoryCosArmor inventory, int slot) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_6982_()) {
            ModObjects.network.sendToAll(new PacketSyncCosArmor(uuid, inventory, slot));
        } else {
            server.m_6846_().m_11314_().forEach(player -> ModObjects.network.sendTo(new PacketSyncCosArmor(uuid, inventory, slot), (ServerPlayer)player));
        }
    }

    public void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(this::handlePlayerDrops);
        MinecraftForge.EVENT_BUS.addListener(this::handlePlayerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(this::handlePlayerLoggedOut);
        MinecraftForge.EVENT_BUS.addListener(this::handleSaveToFile);
        MinecraftForge.EVENT_BUS.addListener(this::handleRegisterCommands);
        MinecraftForge.EVENT_BUS.addListener(this::handleServerStopping);
    }

    public void registerEventsClient() {
        throw new UnsupportedOperationException();
    }

    protected void saveInventory(UUID uuid, InventoryCosArmor inventory) {
        if (inventory == Dummy) {
            return;
        }
        try {
            NbtIo.m_128955_((CompoundTag)inventory.serializeNBT(), (Path)this.getDataFile(uuid).toPath());
        }
        catch (Throwable t) {
            ModObjects.logger.fatal("Failed to save CosmeticArmor data", t);
        }
    }
}

