/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.common.network.server;

import com.sparky.multirecipe.api.common.base.IRecipePair;
import com.sparky.multirecipe.common.impl.RecipePair;
import com.sparky.multirecipe.common.network.server.ClientPacketHandler;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public record SPacketRecipesList(SortedSet<IRecipePair> recipeList = new TreeSet<IRecipePair>(), ResourceLocation selected) {
    public SPacketRecipesList(SortedSet<IRecipePair> recipeList, ResourceLocation selected) {
        if (recipeList != null) {
            this.recipeList.addAll(recipeList);
        }
        this.selected = selected;
    }

    public static void encode(SPacketRecipesList packet, FriendlyByteBuf buffer) {
        if (!packet.recipeList.isEmpty()) {
            buffer.writeInt(packet.recipeList.size());
            for (IRecipePair data : packet.recipeList) {
                buffer.m_130085_(data.getResourceLocation());
                buffer.m_130055_(data.getOutput());
            }
            if (packet.selected != null) {
                buffer.m_130085_(packet.selected);
            }
        }
    }

    public static SPacketRecipesList decode(FriendlyByteBuf buffer) {
        TreeSet<IRecipePair> recipeDataset = new TreeSet<IRecipePair>();
        ResourceLocation selected = null;
        if (buffer.isReadable()) {
            int size = buffer.readInt();
            for (int i = 0; i < size; ++i) {
                recipeDataset.add(new RecipePair(buffer.m_130281_(), buffer.m_130267_()));
            }
            if (buffer.isReadable()) {
                selected = buffer.m_130281_();
            }
        }
        return new SPacketRecipesList(recipeDataset, selected);
    }

    public static void handle(SPacketRecipesList packet) {
        ClientPacketHandler.handle(packet);
    }

    public SortedSet<IRecipePair> getRecipeList() {
        return this.recipeList;
    }

    public ResourceLocation getSelected() {
        return this.selected;
    }
}

