/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.common.network.server;

import com.sparky.multirecipe.api.PolymorphApi;
import com.sparky.multirecipe.api.client.base.IRecipesWidget;
import com.sparky.multirecipe.client.recipe.RecipesWidget;
import com.sparky.multirecipe.common.capability.PolymorphCapabilities;
import com.sparky.multirecipe.common.network.server.SPacketBlockEntityRecipeSync;
import com.sparky.multirecipe.common.network.server.SPacketHighlightRecipe;
import com.sparky.multirecipe.common.network.server.SPacketPlayerRecipeSync;
import com.sparky.multirecipe.common.network.server.SPacketRecipesList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ClientPacketHandler {
    public static void handle(SPacketPlayerRecipeSync packet) {
        LocalPlayer clientPlayerEntity = Minecraft.m_91087_().f_91074_;
        if (clientPlayerEntity != null) {
            PolymorphApi.common().getRecipeData((Player)clientPlayerEntity).ifPresent(recipeData -> {
                recipeData.setRecipesList(packet.getRecipeList());
                clientPlayerEntity.m_9236_().m_7465_().m_44043_(packet.getSelected()).ifPresent(recipeData::setSelectedRecipe);
            });
        }
    }

    public static void handle(SPacketBlockEntityRecipeSync packet) {
        BlockEntity blockEntity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (blockEntity = level.m_7702_(packet.getBlockPos())) != null) {
            PolymorphCapabilities.getRecipeData(blockEntity).ifPresent(recipeData -> level.m_7465_().m_44043_(packet.getSelected()).ifPresent(recipeData::setSelectedRecipe));
        }
    }

    public static void handle(SPacketRecipesList packet) {
        LocalPlayer clientPlayerEntity = Minecraft.m_91087_().f_91074_;
        if (clientPlayerEntity != null) {
            Optional<IRecipesWidget> maybeWidget = RecipesWidget.get();
            maybeWidget.ifPresent(widget -> widget.setRecipesList(packet.getRecipeList(), packet.getSelected()));
            if (maybeWidget.isEmpty()) {
                RecipesWidget.enqueueRecipesList(packet.getRecipeList(), packet.getSelected());
            }
        }
    }

    public static void handle(SPacketHighlightRecipe packet) {
        LocalPlayer clientPlayerEntity = Minecraft.m_91087_().f_91074_;
        if (clientPlayerEntity != null) {
            RecipesWidget.get().ifPresent(widget -> widget.highlightRecipe(packet.getRecipe()));
        }
    }
}

