/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.common.crafting;

import com.sparky.multirecipe.api.PolymorphApi;
import com.sparky.multirecipe.api.common.capability.IBlockEntityRecipeData;
import com.sparky.multirecipe.api.common.capability.IPlayerRecipeData;
import com.sparky.multirecipe.api.common.capability.IRecipeData;
import com.sparky.multirecipe.api.common.capability.IStackRecipeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RecipeSelection {
    public static <T extends Recipe<C>, C extends Container> Optional<RecipeHolder<T>> getPlayerRecipe(AbstractContainerMenu containerMenu, RecipeType<T> type, C inventory, Level level, Player player) {
        return RecipeSelection.getPlayerRecipe(containerMenu, type, inventory, level, player, new ArrayList<RecipeHolder<T>>());
    }

    public static <T extends Recipe<C>, C extends Container> Optional<RecipeHolder<T>> getPlayerRecipe(AbstractContainerMenu containerMenu, RecipeType<T> type, C inventory, Level level, Player player, List<RecipeHolder<T>> recipes) {
        Optional<? extends IPlayerRecipeData> maybeData = PolymorphApi.common().getRecipeData(player);
        maybeData.ifPresent(playerRecipeData -> playerRecipeData.setContainerMenu(containerMenu));
        return RecipeSelection.getRecipe(type, inventory, level, maybeData, recipes);
    }

    public static <T extends Recipe<C>, C extends Container> Optional<RecipeHolder<T>> getStackRecipe(RecipeType<T> type, C inventory, Level level, ItemStack stack) {
        Optional<? extends IStackRecipeData> maybeData = PolymorphApi.common().getRecipeData(stack);
        return RecipeSelection.getRecipe(type, inventory, level, maybeData, new ArrayList<RecipeHolder<T>>());
    }

    public static <T extends Recipe<C>, C extends Container> Optional<RecipeHolder<T>> getBlockEntityRecipe(RecipeType<T> type, C inventory, Level level, BlockEntity blockEntity) {
        Optional<? extends IBlockEntityRecipeData> maybeData = PolymorphApi.common().getRecipeData(blockEntity);
        return RecipeSelection.getRecipe(type, inventory, level, maybeData, new ArrayList<RecipeHolder<T>>());
    }

    private static <T extends Recipe<C>, C extends Container> Optional<RecipeHolder<T>> getRecipe(RecipeType<T> type, C inventory, Level level, Optional<? extends IRecipeData<?>> pOpt, List<RecipeHolder<T>> recipes) {
        if (pOpt.isPresent()) {
            return pOpt.map(recipeData -> recipeData.getRecipe(type, inventory, level, recipes)).orElse(Optional.empty());
        }
        return level.m_7465_().m_44056_(type, inventory, level).stream().findFirst();
    }
}

