/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.common;

import com.mojang.brigadier.CommandDispatcher;
import com.sparky.multirecipe.api.PolymorphApi;
import com.sparky.multirecipe.api.common.capability.IBlockEntityRecipeData;
import com.sparky.multirecipe.api.common.capability.IPlayerRecipeData;
import com.sparky.multirecipe.api.common.capability.IRecipeData;
import com.sparky.multirecipe.api.common.capability.IStackRecipeData;
import com.sparky.multirecipe.common.PolymorphCommonEvents;
import com.sparky.multirecipe.common.PolymorphForgeCapabilities;
import com.sparky.multirecipe.common.capability.PlayerRecipeData;
import com.sparky.multirecipe.server.PolymorphCommands;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEventsListener {
    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        PolymorphCommands.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.register(IPlayerRecipeData.class);
        evt.register(IStackRecipeData.class);
        evt.register(IBlockEntityRecipeData.class);
    }

    @SubscribeEvent
    public void serverAboutToStart(ServerAboutToStartEvent evt) {
        PolymorphApi.common().setServer(evt.getServer());
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PolymorphCommonEvents.playerDisconnected(serverPlayer);
        }
    }

    @SubscribeEvent
    public void serverStopped(ServerStoppedEvent evt) {
        PolymorphApi.common().setServer(null);
    }

    @SubscribeEvent
    public void openContainer(PlayerContainerEvent.Open evt) {
        PolymorphCommonEvents.openContainer(evt.getEntity(), evt.getContainer());
    }

    @SubscribeEvent
    public void levelTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            PolymorphCommonEvents.levelTick(evt.level);
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<BlockEntity> evt) {
        BlockEntity be = (BlockEntity)evt.getObject();
        PolymorphApi.common().tryCreateRecipeData(be).ifPresent(recipeData -> {
            LazyOptional cap = LazyOptional.of(() -> recipeData);
            evt.addCapability(PolymorphForgeCapabilities.BLOCK_ENTITY_RECIPE_DATA_ID, (ICapabilityProvider)new BlockEntityRecipeDataProvider((LazyOptional<IBlockEntityRecipeData>)cap));
        });
    }

    @SubscribeEvent
    public void attachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (entity instanceof Player) {
            PlayerRecipeData data = new PlayerRecipeData((Player)entity);
            LazyOptional cap = LazyOptional.of(() -> data);
            evt.addCapability(PolymorphForgeCapabilities.PLAYER_RECIPE_DATA_ID, (ICapabilityProvider)new PlayerRecipeDataProvider((LazyOptional<IPlayerRecipeData>)cap));
        }
    }

    @SubscribeEvent
    public void attachCapabilitiesStack(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        PolymorphApi.common().tryCreateRecipeData(stack).ifPresent(recipeData -> {
            LazyOptional cap = LazyOptional.of(() -> recipeData);
            evt.addCapability(PolymorphForgeCapabilities.STACK_RECIPE_DATA_ID, (ICapabilityProvider)new StackRecipeDataProvider((LazyOptional<IStackRecipeData>)cap));
        });
    }

    private record PlayerRecipeDataProvider(LazyOptional<IPlayerRecipeData> capability) implements ICapabilitySerializable<Tag>
    {
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
            return PolymorphForgeCapabilities.PLAYER_RECIPE_DATA.orEmpty(capability, this.capability);
        }

        public Tag serializeNBT() {
            return (Tag)this.capability.map(IRecipeData::writeNBT).orElse(new CompoundTag());
        }

        public void deserializeNBT(Tag tag) {
            if (tag instanceof CompoundTag) {
                this.capability.ifPresent(recipeData -> recipeData.readNBT((CompoundTag)tag));
            }
        }
    }

    private record StackRecipeDataProvider(LazyOptional<IStackRecipeData> capability) implements ICapabilitySerializable<Tag>
    {
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
            return PolymorphForgeCapabilities.STACK_RECIPE_DATA.orEmpty(capability, this.capability);
        }

        public Tag serializeNBT() {
            return (Tag)this.capability.map(IRecipeData::writeNBT).orElse(new CompoundTag());
        }

        public void deserializeNBT(Tag tag) {
            if (tag instanceof CompoundTag) {
                this.capability.ifPresent(recipeData -> recipeData.readNBT((CompoundTag)tag));
            }
        }
    }

    private record BlockEntityRecipeDataProvider(LazyOptional<IBlockEntityRecipeData> capability) implements ICapabilitySerializable<Tag>
    {
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
            return PolymorphForgeCapabilities.BLOCK_ENTITY_RECIPE_DATA.orEmpty(capability, this.capability);
        }

        public Tag serializeNBT() {
            return (Tag)this.capability.map(IRecipeData::writeNBT).orElse(new CompoundTag());
        }

        public void deserializeNBT(Tag tag) {
            if (tag instanceof CompoundTag) {
                this.capability.ifPresent(recipeData -> recipeData.readNBT((CompoundTag)tag));
            }
        }
    }
}

