/*
 * Decompiled with CFR 0.152.
 */
package com.sparky.multirecipe.client.recipe;

import com.mojang.datafixers.util.Pair;
import com.sparky.multirecipe.api.PolymorphApi;
import com.sparky.multirecipe.api.client.base.IRecipesWidget;
import com.sparky.multirecipe.api.common.base.IRecipePair;
import com.sparky.multirecipe.client.recipe.widget.PersistentRecipesWidget;
import com.sparky.multirecipe.client.recipe.widget.PlayerRecipesWidget;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class RecipesWidget {
    private static IRecipesWidget widget = null;
    private static Screen lastScreen = null;
    private static Pair<SortedSet<IRecipePair>, ResourceLocation> pendingData = null;

    public static Optional<IRecipesWidget> get() {
        return Optional.ofNullable(widget);
    }

    public static void enqueueRecipesList(SortedSet<IRecipePair> recipesList, ResourceLocation resourceLocation) {
        pendingData = new Pair(recipesList, (Object)resourceLocation);
    }

    public static void create(AbstractContainerScreen<?> containerScreen) {
        if (containerScreen == lastScreen && widget != null) {
            return;
        }
        widget = null;
        Optional<IRecipesWidget> maybeWidget = PolymorphApi.client().getWidget(containerScreen);
        maybeWidget.ifPresent(newWidget -> {
            widget = newWidget;
        });
        if (widget == null) {
            PolymorphApi.client().findCraftingResultSlot(containerScreen).ifPresent(slot -> {
                widget = new PlayerRecipesWidget(containerScreen, (Slot)slot);
            });
        }
        if (widget != null) {
            if (widget instanceof PersistentRecipesWidget && Minecraft.m_91087_().m_91403_() != null) {
                PolymorphApi.common().getPacketDistributor().sendBlockEntityListenerC2S(true);
            }
            widget.initChildWidgets();
            lastScreen = containerScreen;
            if (pendingData != null) {
                widget.setRecipesList((Set)pendingData.getFirst(), (ResourceLocation)pendingData.getSecond());
            }
        } else {
            lastScreen = null;
        }
        pendingData = null;
    }

    public static void clear() {
        if (widget instanceof PersistentRecipesWidget && Minecraft.m_91087_().m_91403_() != null) {
            PolymorphApi.common().getPacketDistributor().sendBlockEntityListenerC2S(false);
        }
        widget = null;
        lastScreen = null;
    }
}

