/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.nightworld.mixin;

import crystalspider.nightworld.NightworldLoader;
import crystalspider.nightworld.api.NightworldPortalChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PortalShape.class})
public abstract class PortalShapeMixin
implements NightworldPortalChecker {
    @Shadow
    private LevelAccessor f_77686_;
    @Shadow
    private Direction f_77688_;
    @Shadow
    private int f_77689_;
    @Shadow
    @Nullable
    private BlockPos f_77690_;
    @Shadow
    private int f_77692_;
    @Shadow
    private int f_77691_;
    private boolean isNightworldPortal = false;

    @Shadow
    private static boolean m_77717_(BlockState state) {
        throw new UnsupportedOperationException("Tried to call a dummy body of a shadowed method: PortalShape#isEmpty(BlockState)");
    }

    @Shadow
    public abstract boolean m_77698_();

    @Mutable
    @Accessor(value="width")
    protected abstract void setWidth(int var1);

    @Override
    public boolean isNightworldPortal() {
        return this.isNightworldPortal;
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)V"}, at={@At(value="TAIL")})
    private void onInit(LevelAccessor world, BlockPos pos, Direction.Axis axis, CallbackInfo ci) {
        if (!world.m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (this.m_77698_() && serverWorld.m_46472_() == NightworldLoader.NIGHTWORLD) {
                this.f_77690_ = null;
                this.setWidth(1);
                this.f_77691_ = 1;
            } else if (!(this.m_77698_() || serverWorld.m_46472_() != Level.f_46428_ && serverWorld.m_46472_() != NightworldLoader.NIGHTWORLD)) {
                this.f_77690_ = this.calculateBottomLeftForNightworld(pos);
                if (this.f_77690_ == null) {
                    this.f_77690_ = pos;
                    this.setWidth(1);
                    this.f_77691_ = 1;
                } else {
                    this.setWidth(this.calculateWidthForNightworld());
                    if (this.f_77692_ > 0) {
                        this.f_77691_ = this.calculateHeightForNightworld();
                        this.isNightworldPortal = true;
                    }
                }
            }
        }
    }

    @Nullable
    private BlockPos calculateBottomLeftForNightworld(BlockPos pos) {
        int i = Math.max(this.f_77686_.m_141937_(), pos.m_123342_() - 21);
        while (pos.m_123342_() > i && PortalShapeMixin.m_77717_(this.f_77686_.m_8055_(pos.m_7495_()))) {
            pos = pos.m_7495_();
        }
        Direction direction = this.f_77688_.m_122424_();
        int j = this.getDistanceUntilEdgeAboveFrameForNightworld(pos, direction) - 1;
        return j < 0 ? null : pos.m_5484_(direction, j);
    }

    private int calculateWidthForNightworld() {
        int i = this.getDistanceUntilEdgeAboveFrameForNightworld(this.f_77690_, this.f_77688_);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int getDistanceUntilEdgeAboveFrameForNightworld(BlockPos pos, Direction direction) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= 21; ++i) {
            blockpos$mutableblockpos.m_122190_((Vec3i)pos).m_122175_(direction, i);
            BlockState blockstate = this.f_77686_.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!PortalShapeMixin.m_77717_(blockstate)) {
                if (!blockstate.m_60713_(Blocks.f_50723_)) break;
                return i;
            }
            BlockState blockstate1 = this.f_77686_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122173_(Direction.DOWN));
            if (!blockstate1.m_60713_(Blocks.f_50723_)) break;
        }
        return 0;
    }

    private int calculateHeightForNightworld() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = this.getDistanceUntilTopForNightworld(blockpos$mutableblockpos);
        return i >= 3 && i <= 21 && this.hasTopFrameForNightworld(blockpos$mutableblockpos, i) ? i : 0;
    }

    private boolean hasTopFrameForNightworld(BlockPos.MutableBlockPos pos, int height) {
        for (int i = 0; i < this.f_77692_; ++i) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122190_((Vec3i)this.f_77690_).m_122175_(Direction.UP, height).m_122175_(this.f_77688_, i);
            if (this.f_77686_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60713_(Blocks.f_50723_)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTopForNightworld(BlockPos.MutableBlockPos pos) {
        for (int i = 0; i < 21; ++i) {
            pos.m_122190_((Vec3i)this.f_77690_).m_122175_(Direction.UP, i).m_122175_(this.f_77688_, -1);
            if (!this.f_77686_.m_8055_((BlockPos)pos).m_60713_(Blocks.f_50723_)) {
                return i;
            }
            pos.m_122190_((Vec3i)this.f_77690_).m_122175_(Direction.UP, i).m_122175_(this.f_77688_, this.f_77692_);
            if (!this.f_77686_.m_8055_((BlockPos)pos).m_60713_(Blocks.f_50723_)) {
                return i;
            }
            for (int j = 0; j < this.f_77692_; ++j) {
                pos.m_122190_((Vec3i)this.f_77690_).m_122175_(Direction.UP, i).m_122175_(this.f_77688_, j);
                BlockState blockstate = this.f_77686_.m_8055_((BlockPos)pos);
                if (!PortalShapeMixin.m_77717_(blockstate)) {
                    return i;
                }
                if (!blockstate.m_60713_(Blocks.f_50142_)) continue;
                ++this.f_77689_;
            }
        }
        return 21;
    }
}

