/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.nightworld.mixin;

import crystalspider.nightworld.api.NightworldPortalChecker;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NetherPortalBlock.class})
public abstract class NetherPortalBlockMixin {
    @Inject(method={"randomTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isValidSpawn(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/EntityType;)Z", shift=At.Shift.BEFORE)})
    private void onRandomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        if (NightworldPortalChecker.isNightworldPortal((Level)world, pos.m_7494_())) {
            if (random.m_216339_(0, 100) < 50) {
                this.handleSpawnEntity(EntityType.f_20501_, state, world, pos);
            } else {
                this.handleSpawnEntity(EntityType.f_20524_, state, world, pos);
            }
        }
    }

    @Redirect(method={"randomTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isValidSpawn(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/EntityType;)Z"))
    private boolean redirectAllowsSpawning(BlockState caller, BlockGetter world, BlockPos pos, EntityType<ZombifiedPiglin> entityType) {
        return !NightworldPortalChecker.isNightworldPortal((Level)world, pos.m_7494_()) && caller.m_60643_(world, pos, entityType);
    }

    private <T extends EntityType<?>> void handleSpawnEntity(T entityType, BlockState state, ServerLevel world, BlockPos pos) {
        Entity entity;
        if (world.m_8055_(pos).m_60643_((BlockGetter)world, pos, entityType) && (entity = entityType.m_262496_(world, pos.m_7494_(), MobSpawnType.STRUCTURE)) != null) {
            entity.m_20091_();
        }
    }
}

