/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.nightworld.mixin;

import crystalspider.nightworld.NightworldLoader;
import crystalspider.nightworld.api.EntityPortal;
import crystalspider.nightworld.api.MinecraftEntity;
import crystalspider.nightworld.api.NightworldPortalChecker;
import crystalspider.nightworld.api.Teleportable;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements Teleportable,
EntityPortal,
MinecraftEntity {
    @Shadow
    public BlockPos f_19819_;

    @Shadow
    protected abstract Optional<BlockUtil.FoundRectangle> m_183318_(ServerLevel var1, BlockPos var2, boolean var3, WorldBorder var4);

    @Override
    public Optional<BlockUtil.FoundRectangle> exitPortal(ServerLevel destination, BlockPos pos, boolean destIsNether, WorldBorder worldBorder) {
        return this.m_183318_(destination, pos, destIsNether, worldBorder);
    }

    @Override
    public Vec3 relativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle rectangle) {
        return this.getRelativePortalPosition(axis, rectangle);
    }

    @Override
    public BlockPos portalEntrancePos() {
        return this.f_19819_;
    }

    @Redirect(method={"handleNetherPortal"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getLevel(Lnet/minecraft/resources/ResourceKey;)Lnet/minecraft/server/level/ServerLevel;"))
    private ServerLevel redirectGetLevel(MinecraftServer caller, ResourceKey<Level> worldKey) {
        Level origin = this.level();
        ServerLevel destination = caller.m_129880_(worldKey);
        if (destination != null && (origin.m_46472_() == Level.f_46428_ || origin.m_46472_() == NightworldLoader.NIGHTWORLD) && destination.m_46472_() == Level.f_46429_ && NightworldPortalChecker.isNightworldPortal(origin, this.portalEntrancePos())) {
            destination = caller.m_129880_(origin.m_46472_() == Level.f_46428_ ? NightworldLoader.NIGHTWORLD : Level.f_46428_);
        }
        return destination;
    }
}

