/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.nightworld.handlers;

import crystalspider.nightworld.NightworldLoader;
import crystalspider.nightworld.api.EntityPortal;
import crystalspider.nightworld.api.Teleportable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityTravelToDimensionEventHandler {
    @SubscribeEvent
    public static void handle(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        MinecraftServer server = entity.m_20194_();
        if (!(server == null || entity.m_213877_() || entity.m_9236_().m_46472_() != NightworldLoader.NIGHTWORLD && event.getDimension() != NightworldLoader.NIGHTWORLD)) {
            ((Teleportable)entity).setCustomPortalInfo(EntityTravelToDimensionEventHandler.getNightworldPortalInfo(entity, server.m_129880_(event.getDimension())));
        }
    }

    private static PortalInfo getNightworldPortalInfo(Entity entity, ServerLevel destination) {
        return ((EntityPortal)entity).exitPortal(destination, entity.m_20183_(), false, destination.m_6857_()).map(rect -> {
            Vec3 vec3d;
            Direction.Axis axis;
            BlockState blockState = entity.m_9236_().m_8055_(((EntityPortal)entity).portalEntrancePos());
            if (blockState.m_61138_((Property)BlockStateProperties.f_61364_)) {
                axis = (Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle rectangle = BlockUtil.m_124334_((BlockPos)((EntityPortal)entity).portalEntrancePos(), (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.m_9236_().m_8055_(pos) == blockState);
                vec3d = ((EntityPortal)entity).relativePortalPosition(axis, rectangle);
            } else {
                axis = Direction.Axis.X;
                vec3d = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_257966_((ServerLevel)destination, (BlockUtil.FoundRectangle)rect, (Direction.Axis)axis, (Vec3)vec3d, (Entity)entity, (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        }).orElse(null);
    }
}

