/*
 * Decompiled with CFR 0.152.
 */
package net.jason13.automessage.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.Builder BUILDER;
    private static Boolean joinMessagesEnabled;
    private static ArrayList<String> joinMessageStrings;
    private static ArrayList<String> joinMessageLinks;
    private static Boolean automessageEnabled;
    private static ArrayList<String> automessageStrings;
    private static ArrayList<String> automessageLinks;
    private static ArrayList<Integer> automessageIntervals;
    private static ArrayList<Integer> automessageSoftLimits;
    private static ArrayList<Integer> automessageHardLimits;
    public static final ForgeConfigSpec.ConfigValue<Boolean> JOIN_MESSAGES_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<List<String>> JOIN_MESSAGE_STRINGS;
    public static final ForgeConfigSpec.ConfigValue<List<String>> JOIN_MESSAGE_LINKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> AUTO_MESSAGE_ENABLED;
    public static final ForgeConfigSpec.ConfigValue<List<String>> AUTO_MESSAGE_STRINGS;
    public static final ForgeConfigSpec.ConfigValue<List<String>> AUTO_MESSAGE_LINKS;
    public static final ForgeConfigSpec.ConfigValue<List<Integer>> AUTO_MESSAGE_INTERVALS;
    public static final ForgeConfigSpec.ConfigValue<List<Integer>> AUTO_MESSAGE_SOFT_LIMITS;
    public static final ForgeConfigSpec.ConfigValue<List<Integer>> AUTO_MESSAGE_HARD_LIMITS;

    private static void buildDefaultClientConfiguration() {
        joinMessagesEnabled = false;
        joinMessageStrings.add(0, "Client only message, links to google");
        joinMessageLinks.add(0, "https://www.google.com");
        joinMessageStrings.add(1, "Optional second message, links to google");
        joinMessageLinks.add(1, "https://www.google.com");
        automessageEnabled = false;
        automessageStrings.add(0, "Default Message One: every 5 seconds, 4 times every session. Unlimited.");
        automessageLinks.add(0, "https://www.google.com");
        automessageIntervals.add(0, 5);
        automessageSoftLimits.add(0, 4);
        automessageHardLimits.add(0, 0);
        automessageStrings.add(1, "Default Message Two: every 8 seconds, unlimited times every session. Limited to 10.");
        automessageLinks.add(1, "https://www.google.com");
        automessageIntervals.add(1, 8);
        automessageSoftLimits.add(1, 0);
        automessageHardLimits.add(1, 10);
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        joinMessageStrings = new ArrayList();
        joinMessageLinks = new ArrayList();
        automessageStrings = new ArrayList();
        automessageLinks = new ArrayList();
        automessageIntervals = new ArrayList();
        automessageSoftLimits = new ArrayList();
        automessageHardLimits = new ArrayList();
        CommonConfig.buildDefaultClientConfiguration();
        BUILDER.push("AutoMessage Common Configuration");
        JOIN_MESSAGES_ENABLED = BUILDER.comment(" Send message(s) when player joins a world?").define("JOIN_MESSAGES_ENABLED", (Object)joinMessagesEnabled);
        JOIN_MESSAGE_STRINGS = BUILDER.comment(" AutoMessage supports multiple messages, however, these are all sent at once.").define("JOIN_MESSAGE_STRINGS", joinMessageStrings);
        JOIN_MESSAGE_LINKS = BUILDER.comment(" Every message should have a link or an empty value.").define("JOIN_MESSAGE_LINKS", joinMessageLinks);
        AUTO_MESSAGE_ENABLED = BUILDER.comment(" Should regular automated messages be sent?").define("AUTO_MESSAGE_ENABLED", (Object)automessageEnabled);
        AUTO_MESSAGE_STRINGS = BUILDER.comment(" What messages should be sent?").define("AUTO_MESSAGE_STRINGS", automessageStrings);
        AUTO_MESSAGE_LINKS = BUILDER.comment(" Should the message have a link? (or leave as empty quotation marks)").define("AUTO_MESSAGE_LINKS", automessageLinks);
        AUTO_MESSAGE_INTERVALS = BUILDER.comment(" How long should we wait between sending this message?").define("AUTO_MESSAGE_INTERVALS", automessageIntervals);
        AUTO_MESSAGE_SOFT_LIMITS = BUILDER.comment(" How many times should the player see this message while playing in one session?").define("AUTO_MESSAGE_SOFT_LIMITS", automessageSoftLimits);
        AUTO_MESSAGE_HARD_LIMITS = BUILDER.comment(" How many times should this player see this message in this world?").define("AUTO_MESSAGE_HARD_LIMITS", automessageHardLimits);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

