/*
 * Decompiled with CFR 0.152.
 */
package net.jason13.automessage.capability;

import java.util.List;
import net.jason13.automessage.config.CommonConfig;
import net.minecraft.nbt.CompoundTag;

public class MessagingCapability {
    private int playtime = 0;
    private int[] soft_counts = new int[((List)CommonConfig.AUTO_MESSAGE_STRINGS.get()).size()];
    private int[] hard_counts = new int[((List)CommonConfig.AUTO_MESSAGE_STRINGS.get()).size()];

    public void incrementPlaytime() {
        ++this.playtime;
    }

    public void incrementSoftAtIndex(int index) {
        int n = index;
        this.soft_counts[n] = this.soft_counts[n] + 1;
    }

    public void incrementHardAtIndex(int index) {
        int n = index;
        this.hard_counts[n] = this.hard_counts[n] + 1;
    }

    public int getPlaytime() {
        return this.playtime;
    }

    public int[] getSoftCounts() {
        return this.soft_counts;
    }

    public int[] getHardCounts() {
        return this.hard_counts;
    }

    public void resetPlaytime() {
        this.playtime = 0;
    }

    public void resetSoftCounts() {
        for (int i = 0; i < this.soft_counts.length; ++i) {
            this.soft_counts[i] = 0;
        }
    }

    public void resetHardCounts() {
        for (int i = 0; i < this.hard_counts.length; ++i) {
            this.hard_counts[i] = 0;
        }
    }

    public void resetAllValues() {
        this.resetPlaytime();
        this.resetSoftCounts();
        this.resetHardCounts();
    }

    public void copyOnDeath(MessagingCapability source) {
        this.playtime = source.playtime;
        this.soft_counts = source.soft_counts;
        this.hard_counts = source.hard_counts;
    }

    public void saveNBTData(CompoundTag nbt) {
        nbt.m_128405_("playtime", this.playtime);
        nbt.m_128385_("soft_counts", this.soft_counts);
        nbt.m_128385_("hard_counts", this.hard_counts);
    }

    public void loadNBTData(CompoundTag nbt) {
        this.playtime = nbt.m_128451_("playtime");
        this.soft_counts = nbt.m_128465_("soft_counts");
        this.hard_counts = nbt.m_128465_("hard_counts");
    }
}

