/*
 * Decompiled with CFR 0.152.
 */
package net.jason13.automessage;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.jason13.automessage.capability.MessagingCapability;
import net.jason13.automessage.capability.MessagingProvider;
import net.jason13.automessage.config.CommonConfig;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="automessage")
public class AutoMessage {
    public static final String MOD_ID = "automessage";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CLIENT_CHECK_PATH = "config/automessage_client_check.txt";

    public AutoMessage() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC, "automessage-common.toml");
    }

    private static void writeBooleanToFile(boolean value, String pPath) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(pPath));){
            writer.write(String.valueOf(value));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean readBooleanFromFile(String pPath) {
        boolean bl;
        BufferedReader reader = new BufferedReader(new FileReader(pPath));
        try {
            String line = reader.readLine();
            bl = Boolean.parseBoolean(line);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        File file = new File(CLIENT_CHECK_PATH);
        if (!file.exists()) {
            AutoMessage.writeBooleanToFile(false, CLIENT_CHECK_PATH);
        }
    }

    @SubscribeEvent
    public void onPlayerJoinLevelEvent(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ && (entity = event.getEntity()) instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            if (((Boolean)CommonConfig.JOIN_MESSAGES_ENABLED.get()).booleanValue() && !AutoMessage.readBooleanFromFile(CLIENT_CHECK_PATH)) {
                for (int index = 0; index < ((List)CommonConfig.JOIN_MESSAGE_STRINGS.get()).size(); ++index) {
                    int i = index;
                    if (((String)((List)CommonConfig.JOIN_MESSAGE_LINKS.get()).get(i)).length() > 3) {
                        player.m_213846_((Component)Component.m_237113_((String)((String)((List)CommonConfig.JOIN_MESSAGE_STRINGS.get()).get(i))).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, String.valueOf(((List)CommonConfig.JOIN_MESSAGE_LINKS.get()).get(i))))));
                        continue;
                    }
                    player.m_213846_((Component)Component.m_237113_((String)((String)((List)CommonConfig.JOIN_MESSAGE_STRINGS.get()).get(i))));
                }
                AutoMessage.writeBooleanToFile(true, CLIENT_CHECK_PATH);
            }
        }
        if (!event.getLevel().f_46443_ && event.getEntity() instanceof ServerPlayer) {
            event.getEntity().getCapability(MessagingProvider.CAPABILITY).ifPresent(MessagingCapability::resetSoftCounts);
        }
    }

    @SubscribeEvent
    public void onRegisterCapabilitiesEvent(RegisterCapabilitiesEvent event) {
        event.register(MessagingCapability.class);
    }

    @SubscribeEvent
    public void onPlayerCloneEvent(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(MessagingProvider.CAPABILITY).ifPresent(oldStore -> event.getOriginal().getCapability(MessagingProvider.CAPABILITY).ifPresent(newStore -> newStore.copyOnDeath((MessagingCapability)oldStore)));
        }
    }

    @SubscribeEvent
    public void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(MessagingProvider.CAPABILITY).isPresent()) {
            event.addCapability(new ResourceLocation(MOD_ID, "properties"), (ICapabilityProvider)new MessagingProvider());
        }
    }

    @SubscribeEvent
    public void onServerStartTick(TickEvent.ServerTickEvent event) {
        if (((Boolean)CommonConfig.AUTO_MESSAGE_ENABLED.get()).booleanValue()) {
            boolean customFlags;
            TickEvent.Phase ePhase = event.phase;
            boolean eventFlagPhase = ePhase == TickEvent.Phase.START;
            TickEvent.Type eType = event.type;
            boolean eventFlagType = eType == TickEvent.Type.SERVER;
            LogicalSide eSide = event.side;
            boolean eventFlagSide = eSide == LogicalSide.SERVER;
            boolean eventFlags = eventFlagPhase && eventFlagType && eventFlagSide;
            MinecraftServer server = event.getServer();
            List players = server.m_6846_().m_11314_();
            boolean playersExistOnServer = !players.isEmpty();
            int ticks = server.m_129921_();
            boolean oneSecondIntervalHit = ticks % 20 == 0;
            boolean bl = customFlags = playersExistOnServer && oneSecondIntervalHit;
            if (eventFlags && customFlags) {
                for (ServerPlayer player : players) {
                    player.getCapability(MessagingProvider.CAPABILITY).ifPresent(messenger -> {
                        for (int index = 0; index < ((List)CommonConfig.AUTO_MESSAGE_STRINGS.get()).size(); ++index) {
                            boolean MESSAGE_HARD_LIMIT_NOT_HIT;
                            int i = index;
                            boolean MESSAGE_INTERVAL_HIT = messenger.getPlaytime() % (Integer)((List)CommonConfig.AUTO_MESSAGE_INTERVALS.get()).get(i) == 0;
                            boolean MESSAGE_SOFT_LIMIT_NOT_HIT = messenger.getSoftCounts()[i] < (Integer)((List)CommonConfig.AUTO_MESSAGE_SOFT_LIMITS.get()).get(i) || (Integer)((List)CommonConfig.AUTO_MESSAGE_SOFT_LIMITS.get()).get(i) == 0;
                            boolean bl = MESSAGE_HARD_LIMIT_NOT_HIT = messenger.getHardCounts()[i] < (Integer)((List)CommonConfig.AUTO_MESSAGE_HARD_LIMITS.get()).get(i) || (Integer)((List)CommonConfig.AUTO_MESSAGE_HARD_LIMITS.get()).get(i) == 0;
                            if (!MESSAGE_INTERVAL_HIT || !MESSAGE_SOFT_LIMIT_NOT_HIT || !MESSAGE_HARD_LIMIT_NOT_HIT) continue;
                            if (((String)((List)CommonConfig.AUTO_MESSAGE_LINKS.get()).get(i)).length() > 3) {
                                player.m_213846_((Component)Component.m_237113_((String)((String)((List)CommonConfig.AUTO_MESSAGE_STRINGS.get()).get(i))).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, String.valueOf(((List)CommonConfig.AUTO_MESSAGE_LINKS.get()).get(i))))));
                            } else {
                                player.m_213846_((Component)Component.m_237113_((String)((String)((List)CommonConfig.AUTO_MESSAGE_STRINGS.get()).get(i))));
                            }
                            messenger.incrementSoftAtIndex(i);
                            messenger.incrementHardAtIndex(i);
                        }
                        messenger.incrementPlaytime();
                    });
                }
            }
        }
    }
}

