/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.capability.FamiliarProvider;
import ovh.corail.tombstone.capability.IFamiliar;
import ovh.corail.tombstone.helper.EntityHelper;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"canAttack"}, at={@At(value="RETURN")}, cancellable=true)
    private void methodCanAttack(LivingEntity target, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        LivingEntity entity = (LivingEntity)this;
        if (((Boolean)callbackInfoReturnable.getReturnValue()).booleanValue() && target != null && EntityHelper.areOwnerOrServants(entity, target)) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getAbsorptionAmount"}, at={@At(value="RETURN")}, cancellable=true)
    private void methodGetAbsorptionAmount(CallbackInfoReturnable<Float> callbackInfoReturnable) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.getCapability(FamiliarProvider.FAMILIAR_CAPABILITY).map(IFamiliar::isActive).orElse(false).booleanValue()) {
            callbackInfoReturnable.setReturnValue((Object)Float.valueOf(((Float)callbackInfoReturnable.getReturnValue()).floatValue() + 0.5f));
        }
    }

    @Inject(method={"getArmorValue"}, at={@At(value="RETURN")}, cancellable=true)
    private void methodGetArmorValue(CallbackInfoReturnable<Float> callbackInfoReturnable) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.getCapability(FamiliarProvider.FAMILIAR_CAPABILITY).map(IFamiliar::isActive).orElse(false).booleanValue()) {
            callbackInfoReturnable.setReturnValue((Object)Float.valueOf(((Float)callbackInfoReturnable.getReturnValue()).floatValue() + 1.0f));
        }
    }
}

