/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.capability.IFamiliar;

public class FamiliarProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "cap_familiar");
    public static final Capability<IFamiliar> FAMILIAR_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IFamiliar>(){});
    private final LazyOptional<IFamiliar> holderCap;

    public FamiliarProvider(NonNullSupplier<IFamiliar> nonNullSupplier) {
        this.holderCap = LazyOptional.of(nonNullSupplier);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return FAMILIAR_CAPABILITY.orEmpty(cap, this.holderCap);
    }

    public CompoundTag serializeNBT() {
        return this.holderCap.map(cap -> Optional.ofNullable((CompoundTag)cap.serializeNBT()).orElse(new CompoundTag())).orElse(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.holderCap.ifPresent(cap -> cap.deserializeNBT((Tag)nbt));
    }
}

