/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Optional;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.JmUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ScrollPane
extends ObjectSelectionList<ScrollPaneEntry> {
    public int paneWidth = 0;
    public int paneHeight = 0;
    public Point2D.Double origin = new Point2D.Double();
    protected Button selected = null;
    private Integer frameColor = new Color(-6250336).getRGB();
    private Minecraft mc;
    private int _mouseX;
    private int _mouseY;
    private boolean showFrame = true;
    private int firstVisibleIndex;
    private int lastVisibleIndex;
    private boolean drawPartialScrollable = true;
    private boolean renderSolidBackground = false;
    private boolean renderDecorations = true;
    private boolean scrollVisible = true;
    protected boolean renderSelection;

    public ScrollPane(JmUI parent, Minecraft mc, int width, int height, List<? extends Button> items, int itemHeight, int itemGap) {
        super(mc, width, height, 16, itemHeight + itemGap);
        for (Button button : items) {
            super.m_7085_((AbstractSelectionList.Entry)new ScrollPaneEntry(this, button));
        }
        this.paneWidth = width;
        this.paneHeight = height;
        this.mc = mc;
    }

    public int m_252754_() {
        return (int)this.origin.getX();
    }

    public int m_252907_() {
        return (int)this.origin.getY();
    }

    public int getSlotHeight() {
        return this.f_93619_;
    }

    public void setDrawPartialScrollable(boolean value) {
        this.drawPartialScrollable = value;
    }

    public void setDimensions(int width, int height, int marginTop, int marginBottom, int x, int y) {
        super.m_306878_(width, height, x, y);
        this.paneWidth = width;
        this.paneHeight = height;
        this.origin.setLocation(x, y);
    }

    protected int m_5773_() {
        return super.m_5773_();
    }

    protected ScrollPaneEntry getEntry(int index) {
        return (ScrollPaneEntry)super.m_93500_(index);
    }

    public boolean m_7987_(int i) {
        return super.m_7987_(i);
    }

    public Button mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (ScrollPaneEntry entry : super.m_6702_()) {
                Button item = entry.item;
                if (item == null || !this.inFullView(item)) continue;
                if (item.m_274382_() && item.m_6375_(mouseX, mouseY, mouseButton)) {
                    item.m_5691_();
                    return item;
                }
                item.clickScrollable(this.mc, mouseX, mouseY);
            }
        }
        return null;
    }

    public Button getButton(int mouseX, int mouseY) {
        for (ScrollPaneEntry entry : super.m_6702_()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item) || !item.m_274382_() || !item.mouseOver(mouseX, mouseY)) continue;
            return item;
        }
        return null;
    }

    public void m_87963_(GuiGraphics graphics, int mX, int mY, float partialTicks) {
        this._mouseX = mX;
        this._mouseY = mY;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
        super.m_93488_(false);
        graphics.m_280168_().m_85836_();
        RenderWrapper.enableDepthTest();
        this.renderBackground(graphics);
        super.m_87963_(graphics, mX, mY, partialTicks);
        graphics.m_280168_().m_85849_();
    }

    protected void renderBackground(GuiGraphics graphics) {
        int width = this.m_5711_();
        float alpha = 0.4f;
        DrawUtil.drawRectangle(graphics.m_280168_(), this.m_252754_(), this.m_252907_(), width, this.paneHeight, Color.BLACK.getRGB(), this.renderSolidBackground ? 1.0f : alpha);
        boolean bl = this.scrollVisible = 0 < this.m_93518_();
        if (this.scrollVisible) {
            DrawUtil.drawRectangle(graphics.m_280168_(), this.m_252754_() + width - 6, super.m_252907_(), 5.0, this.paneHeight, Color.BLACK.getRGB(), alpha);
        }
        if (this.showFrame) {
            alpha = 1.0f;
            DrawUtil.drawRectangle(graphics.m_280168_(), this.m_252754_() - 1, this.m_252907_() - 1, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.m_280168_(), this.m_252754_() - 1, this.m_252907_() + this.paneHeight, width + 2, 1.0, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.m_280168_(), this.m_252754_() - 1, this.m_252907_() - 1, 1.0, this.paneHeight + 1, this.frameColor, alpha);
            DrawUtil.drawRectangle(graphics.m_280168_(), width + (this.scrollVisible ? 1 : 0) + this.m_252754_(), this.m_252907_() - 1, 1.0, this.paneHeight + 2, this.frameColor, alpha);
        }
    }

    public void renderItem(GuiGraphics graphics, int index, int y, int x, int l, int var6, int var7, float f) {
        if (this.firstVisibleIndex == -1) {
            this.firstVisibleIndex = index;
        }
        this.lastVisibleIndex = Math.max(this.lastVisibleIndex, index);
        int margin = 4;
        int itemX = this.m_252754_() + 2;
        Button item = ((ScrollPaneEntry)super.m_93500_((int)index)).item;
        item.setScrollablePosition(itemX, y);
        item.setScrollableWidth(this.paneWidth - 4);
        if (this.inFullView(item)) {
            item.drawScrollable(graphics, this.mc, this._mouseX, this._mouseY);
            item.renderSpecialDecoration(graphics, this._mouseX, this._mouseY, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.f_93619_);
        } else {
            int paneBottomY = this.m_252907_() + this.paneHeight;
            int itemBottomY = y + item.getButtonHeight();
            Integer drawY = null;
            int yDiff = 0;
            if (y < this.m_252907_() && itemBottomY > this.m_252907_()) {
                drawY = this.m_252907_();
                yDiff = drawY - y;
            } else if (y < paneBottomY && itemBottomY > paneBottomY) {
                drawY = y;
                yDiff = itemBottomY - paneBottomY;
            }
            if (drawY != null && this.drawPartialScrollable) {
                item.drawPartialScrollable(graphics, this.mc, itemX, drawY, item.getScrollableWidth(), item.getButtonHeight() - yDiff);
            }
        }
    }

    protected void m_240140_(GuiGraphics guiGraphics, int i, int j, int k, int l, int m) {
        if (this.renderSelection) {
            super.m_240140_(guiGraphics, i, j, k, l, m);
        }
    }

    protected void m_7154_(GuiGraphics graphics, int x, int y) {
        if (this.renderDecorations) {
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            RenderWrapper.depthFunc(515);
            RenderWrapper.disableDepthTest();
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 0, 1);
            RenderWrapper.disableTexture();
            RenderWrapper.setShader(GameRenderer::m_172811_);
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_5483_((double)super.m_252754_(), (double)(super.m_252907_() + 5), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)super.m_307439_(), (double)(super.m_252907_() + 5), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)super.m_307439_(), (double)super.m_252907_(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)super.m_252754_(), (double)super.m_252907_(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)super.m_252754_(), (double)super.m_306468_(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)super.m_307439_(), (double)super.m_306468_(), 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)super.m_307439_(), (double)(super.m_306468_() - 5), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            bufferbuilder.m_5483_((double)super.m_252754_(), (double)(super.m_306468_() - 5), 0.0).m_6122_(0, 0, 0, 0).m_5752_();
            tesselator.m_85914_();
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        if (this.m_6702_().isEmpty()) {
            return false;
        }
        if (button == 0 && this.f_93399_) {
            if (mouseY < (double)super.m_252907_()) {
                this.m_93410_(0.0);
            } else {
                double d0 = Math.max(1, this.m_93518_());
                int i = super.m_306468_() - super.m_252907_();
                int j = Mth.m_14045_((int)((int)((float)(i * i) / (float)this.m_5775_())), (int)32, (int)(i - 8));
                double d1 = Math.max(1.0, d0 / (double)(i - j));
                this.m_93410_(this.m_93517_() + mouseDY * d1);
            }
            return true;
        }
        return false;
    }

    public boolean isScrollVisible() {
        return this.scrollVisible;
    }

    public boolean inFullView(Button item) {
        return item.m_252907_() >= this.m_252907_() && item.m_252907_() + item.getButtonHeight() <= this.m_252907_() + this.paneHeight;
    }

    protected int m_5756_() {
        return this.paneWidth + this.m_252754_();
    }

    protected void m_93481_(double xPos, double yPos, int button) {
        double rightX = this.m_252754_() + this.m_5711_() - 5;
        this.f_93399_ = button == 0 && xPos >= rightX && xPos < rightX + 10.0;
    }

    protected int m_5775_() {
        return super.m_5775_();
    }

    public int m_5711_() {
        boolean scrollVisible = 0 < this.m_93518_();
        return this.paneWidth + (scrollVisible ? 5 : 0);
    }

    public int getFitWidth(Font fr) {
        int fit = 0;
        for (ScrollPaneEntry entry : this.m_6702_()) {
            fit = Math.max(fit, entry.item.getFitWidth(fr));
        }
        return fit;
    }

    public int m_93518_() {
        return super.m_93518_();
    }

    public boolean m_5953_(double posX, double posY) {
        int topY = this.m_252907_();
        int bottomY = this.m_252907_() + this.paneHeight;
        int leftX = this.m_252754_();
        int rightX = this.m_252754_() + this.m_5711_();
        return posY >= (double)topY && posY <= (double)bottomY && posX >= (double)leftX && posX <= (double)rightX;
    }

    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        return Optional.empty();
    }

    public void m_94757_(double mouseX, double mouseY) {
        for (ScrollPaneEntry entry : super.m_6702_()) {
            Button item = entry.item;
            if (item == null || !this.inFullView(item)) continue;
            item.m_94757_(mouseX, mouseY);
        }
        super.m_94757_(mouseX, mouseY);
    }

    public void setRenderSolidBackground(boolean value) {
        this.renderSolidBackground = value;
    }

    public void setRenderDecorations(boolean value) {
        this.renderDecorations = value;
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
    }

    class ScrollPaneEntry
    extends ObjectSelectionList.Entry<ScrollPaneEntry> {
        private ScrollPane parent;
        private Button item;

        public ScrollPaneEntry(ScrollPane parent, Button item) {
            this.parent = parent;
            this.item = item;
        }

        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int l, int var6, int var7, int p_230432_8_, boolean p_230432_9_, float f) {
            this.parent.renderItem(graphics, index, y, x, l, var6, var7, f);
        }

        public Component m_142172_() {
            return null;
        }
    }
}

