/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.forge;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import journeymap.client.event.forge.ForgeEventHandlerManager;
import journeymap.client.event.handlers.ChatEventHandler;
import journeymap.common.Journeymap;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeChatEvents
implements ForgeEventHandlerManager.EventHandler {
    private final ChatEventHandler chatEventHandler = new ChatEventHandler();

    public boolean onChatEvent(String message) {
        try {
            return this.chatEventHandler.onChatEvent("/" + message);
        }
        catch (CommandSyntaxException e) {
            Journeymap.getLogger().error((Object)e);
            return false;
        }
    }

    @SubscribeEvent
    public void invoke(ClientChatReceivedEvent event) {
        Component component = this.chatEventHandler.onClientChatEventReceived(event.getMessage());
        if (component != null) {
            event.setMessage(component);
        }
    }

    public ChatEventHandler getHandler() {
        return this.chatEventHandler;
    }
}

