/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.server;

import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.ItemStackCPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class ItemStackSPacket {
    private ItemStack value;
    private int slot;

    public ItemStackSPacket(FriendlyByteBuf buf) {
        this.value = buf.m_130267_();
        this.slot = buf.readInt();
    }

    public ItemStackSPacket(ItemStack stack, int slotnum) {
        this.value = stack;
        this.slot = slotnum;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130055_(this.value);
        buf.writeInt(this.slot);
    }

    public void handle(CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            PlayerData data;
            ServerPlayer sender = ctx.getSender();
            if (!sender.m_9236_().m_5776_() && (data = ((IPlayerData)sender).getPlayerData()) != null && this.value != null) {
                data.inventory[this.slot] = this.value;
                for (Player sp : ctx.getSender().m_9236_().m_6907_()) {
                    Networking.sendToClient(new ItemStackCPacket(this.value, this.slot, sender.m_20148_()), (ServerPlayer)sp);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

