/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.events_on_client.ClientOnlyForgeSetup;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.DistExecutor;

public class WhitelistCPacket {
    private String value;
    private boolean setconfig;
    private UUID uuid;

    public WhitelistCPacket(FriendlyByteBuf buf) {
        this.value = buf.m_130277_();
        this.setconfig = buf.readBoolean();
        this.uuid = buf.m_130259_();
    }

    public WhitelistCPacket(String slotnum, boolean setConfigForClient, UUID uuid) {
        this.value = slotnum;
        this.setconfig = setConfigForClient;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.value);
        buf.writeBoolean(this.setconfig);
        buf.m_130077_(this.uuid);
    }

    public void handle(CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (Player target : Minecraft.m_91087_().f_91073_.m_6907_()) {
            PlayerData data;
            if (!target.m_20148_().equals(this.uuid) || (data = ((IPlayerData)target).getPlayerData()) == null) continue;
            data.whitelist = ModUtils.stringExist(this.value) ? this.value : "empty";
            if (target != Minecraft.m_91087_().f_91074_ || !this.setconfig) continue;
            try {
                ConfigHolder.COMMON.whitelist.set((Object)data.whitelist);
                ClientOnlyForgeSetup.whitelist = data.whitelist;
            }
            catch (Exception exception) {}
        }
    }
}

