/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.cooking;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultCookingDisplay
extends BasicDisplay
implements SimpleGridMenuDisplay {
    private RecipeHolder<?> recipe;
    private float xp;
    private double cookTime;

    public DefaultCookingDisplay(RecipeHolder<? extends AbstractCookingRecipe> recipe) {
        this(EntryIngredients.ofIngredients((List<Ingredient>)((AbstractCookingRecipe)recipe.f_291008_()).m_7527_()), Collections.singletonList(EntryIngredients.of(((AbstractCookingRecipe)recipe.f_291008_()).m_8043_(BasicDisplay.registryAccess()))), recipe, ((AbstractCookingRecipe)recipe.f_291008_()).m_43750_(), ((AbstractCookingRecipe)recipe.f_291008_()).m_43753_());
    }

    public DefaultCookingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, CompoundTag tag) {
        this(input, output, RecipeManagerContext.getInstance().byId(tag, "location"), tag.m_128457_("xp"), tag.m_128459_("cookTime"));
    }

    public DefaultCookingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, @Nullable RecipeHolder<?> recipe, float xp, double cookTime) {
        super(input, output, Optional.ofNullable(recipe).map(RecipeHolder::f_291676_));
        this.recipe = recipe;
        this.xp = xp;
        this.cookTime = cookTime;
    }

    public float getXp() {
        return this.xp;
    }

    public double getCookingTime() {
        return this.cookTime;
    }

    @ApiStatus.Internal
    public Optional<RecipeHolder<?>> getOptionalRecipe() {
        return Optional.ofNullable(this.recipe);
    }

    @Override
    public int getWidth() {
        return 1;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public static <R extends DefaultCookingDisplay> BasicDisplay.Serializer<R> serializer(BasicDisplay.Serializer.RecipeLessConstructor<R> constructor) {
        return BasicDisplay.Serializer.ofRecipeLess(constructor, (display, tag) -> {
            tag.m_128350_("xp", display.getXp());
            tag.m_128347_("cookTime", display.getCookingTime());
        });
    }
}

