/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.tag;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.MatrixUtils;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.client.categories.tag.TagNodeWidget;
import me.shedaniel.rei.plugin.common.displays.tag.TagNode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ReferenceTagNodeWidget<S, T>
extends TagNodeWidget<S, T> {
    private final TagNode<S> node;
    private final Rectangle overflowBounds;
    private final Rectangle bounds;
    private final Slot slot;
    private final List<? extends GuiEventListener> children;

    public ReferenceTagNodeWidget(TagNode<S> node, Function<Holder<S>, EntryStack<T>> mapper, Rectangle overflowBounds) {
        this.node = node;
        this.overflowBounds = overflowBounds;
        this.bounds = new Rectangle(0, 0, 24, 23);
        this.slot = Widgets.createSlot(new Rectangle(0, 0, 18, 18)).disableBackground().disableHighlight().disableTooltips().entries(EntryIngredients.ofTag(node.getReference(), mapper));
        this.children = Collections.singletonList(this.slot);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.overflowBounds.intersects(MatrixUtils.transform(graphics.m_280168_().m_85850_().m_252922_(), this.getBounds()))) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            graphics.m_280444_(new ResourceLocation("textures/gui/sprites/advancements/task_frame_unobtained.png"), this.bounds.x - 1, this.bounds.x - 1 + 26, this.bounds.y - 1, this.bounds.y - 1 + 26, 0, 0.0f, 1.0f, 0.0f, 1.0f);
            this.slot.getBounds().setLocation(this.bounds.getCenterX() - this.slot.getBounds().getWidth() / 2, this.bounds.y + (this.bounds.height - this.slot.getBounds().getHeight()) / 2 + 1);
            this.slot.m_88315_(graphics, mouseX, mouseY, delta);
            if (this.containsMouse(mouseX, mouseY)) {
                Tooltip.create(new Component[]{Component.m_237113_((String)("#" + this.node.getReference().f_203868_().toString()))}).queue();
            }
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }
}

