/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.registry;

import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public class RecipeManagerContextImpl<P extends REIPlugin<?>>
implements RecipeManagerContext<P> {
    private static final Comparator<RecipeHolder<?>> RECIPE_COMPARATOR = Comparator.comparing(o -> o.f_291676_().m_135827_()).thenComparing(o -> o.f_291676_().m_135815_());
    private final Supplier<RecipeManager> recipeManager;
    private List<RecipeHolder<?>> sortedRecipes = null;

    public RecipeManagerContextImpl(Supplier<RecipeManager> recipeManager) {
        this.recipeManager = recipeManager;
    }

    public static Supplier<RecipeManager> supplier() {
        return () -> (RecipeManager)EnvExecutor.getEnvSpecific(() -> () -> Minecraft.m_91087_().m_91403_().m_105141_(), () -> () -> GameInstance.getServer().m_129894_());
    }

    @Override
    public List<RecipeHolder<?>> getAllSortedRecipes() {
        if (this.sortedRecipes == null) {
            this.sortedRecipes = this.getRecipeManager().m_44051_().parallelStream().sorted(RECIPE_COMPARATOR).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.sortedRecipes);
    }

    @Override
    public RecipeManager getRecipeManager() {
        return this.recipeManager.get();
    }

    @Override
    public void startReload() {
        this.sortedRecipes = null;
    }
}

