/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.display;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryManager;
import me.shedaniel.rei.impl.client.registry.display.DisplayKey;
import me.shedaniel.rei.impl.client.registry.display.DisplaysHolder;
import me.shedaniel.rei.impl.client.registry.display.RemappingMap;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class DisplaysHolderImpl
implements DisplaysHolder {
    private final boolean cache;
    private final SetMultimap<DisplayKey, Display> displaysByKey = Multimaps.newSetMultimap(new IdentityHashMap(), ReferenceOpenHashSet::new);
    private final Map<CategoryIdentifier<?>, DisplaysList> displays = new ConcurrentHashMap();
    private final Map<CategoryIdentifier<?>, List<Display>> unmodifiableDisplays;
    private final WeakHashMap<Display, Object> displaysBase = new WeakHashMap();
    private Set<Display> displaysCached = new ReferenceOpenHashSet();
    private Set<Display> displaysNotCached = Collections.synchronizedSet(new ReferenceOpenHashSet());
    private boolean preprocessed = false;
    private SetMultimap<EntryStack<?>, Display> displaysByInput;
    private SetMultimap<EntryStack<?>, Display> displaysByOutput;
    private final MutableInt displayCount = new MutableInt(0);

    public DisplaysHolderImpl(boolean init) {
        this.cache = init && ConfigObject.getInstance().doesCacheDisplayLookup();
        this.unmodifiableDisplays = new RemappingMap<CategoryIdentifier, DisplaysList>(Collections.unmodifiableMap(this.displays), list -> {
            if (list == null) {
                return null;
            }
            return ((DisplaysList)list).synchronizedList;
        }, key -> CategoryRegistry.getInstance().tryGet(key).isPresent());
        this.displaysByInput = this.createSetMultimap();
        this.displaysByOutput = this.createSetMultimap();
    }

    @Override
    public boolean doesCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Display display, @Nullable Object origin) {
        this.displays.computeIfAbsent(display.getCategoryIdentifier(), location -> new DisplaysList()).add(display);
        Optional<ResourceLocation> location2 = display.getDisplayLocation();
        if (location2.isPresent()) {
            this.displaysByKey.put((Object)DisplayKey.create(display.getCategoryIdentifier(), location2.get()), (Object)display);
        }
        this.displayCount.increment();
        if (origin != null) {
            WeakHashMap<Display, Object> weakHashMap = this.displaysBase;
            synchronized (weakHashMap) {
                this.displaysBase.put(display, origin);
            }
        }
        if (this.cache) {
            if (!this.preprocessed) {
                this.displaysNotCached.add(display);
            } else {
                this.process(display);
                this.displaysCached.add(display);
            }
        } else {
            this.displaysNotCached.add(display);
        }
    }

    @Override
    public int size() {
        return this.displayCount.intValue();
    }

    @Override
    public Map<CategoryIdentifier<?>, List<Display>> get() {
        return this.unmodifiableDisplays;
    }

    @Override
    public void endReload() {
        if (this.cache) {
            InternalLogger.getInstance().debug("Processing %d displays for optimal lookup performance...", this.size());
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.displaysCached = new ReferenceOpenHashSet(this.size());
            this.displaysByInput = this.createSetMultimap();
            this.displaysByOutput = this.createSetMultimap();
            for (Display display : this.displaysNotCached) {
                this.process(display);
            }
            this.displaysCached.addAll(this.displaysNotCached);
            this.displaysNotCached = Set.of();
            this.preprocessed = true;
            InternalLogger.getInstance().debug("Processed displays for optimal lookup performance in %s.", stopwatch.stop());
        }
    }

    private void process(Display display) {
        for (EntryIngredient input : display.getInputEntries()) {
            for (EntryStack stack : input) {
                this.displaysByInput.put((Object)stack, (Object)display);
            }
        }
        for (EntryIngredient output : display.getOutputEntries()) {
            for (EntryStack stack : output) {
                this.displaysByOutput.put((Object)stack, (Object)display);
            }
        }
    }

    @Override
    public Set<Display> getDisplaysByKey(DisplayKey key) {
        return this.displaysByKey.get((Object)key);
    }

    @Override
    public boolean isCached(Display display) {
        return this.cache && this.displaysCached.contains(display);
    }

    @Override
    public Set<Display> getDisplaysNotCached() {
        return this.displaysNotCached;
    }

    @Override
    public Set<Display> getDisplaysByInput(EntryStack<?> stack) {
        return this.displaysByInput.get(stack);
    }

    @Override
    public Set<Display> getDisplaysByOutput(EntryStack<?> stack) {
        return this.displaysByOutput.get(stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object getDisplayOrigin(Display display) {
        WeakHashMap<Display, Object> weakHashMap = this.displaysBase;
        synchronized (weakHashMap) {
            Object origin = this.displaysBase.get(display);
            if (origin != null) {
                return origin;
            }
        }
        return DisplayHistoryManager.INSTANCE.getPossibleOrigin(this, display);
    }

    private SetMultimap<EntryStack<?>, Display> createSetMultimap() {
        return Multimaps.newSetMultimap((Map)new Object2ObjectOpenCustomHashMap(Math.max(10000, this.size() * 5 / 2), new Hash.Strategy<EntryStack<?>>(){

            public int hashCode(EntryStack<?> stack) {
                return Long.hashCode(EntryStacks.hashFuzzy(stack));
            }

            public boolean equals(EntryStack<?> o1, EntryStack<?> o2) {
                return EntryStacks.equalsFuzzy(o1, o2);
            }
        }), ReferenceOpenHashSet::new);
    }

    private static class DisplaysList
    extends ArrayList<Display> {
        private final List<Display> synchronizedList;

        public DisplaysList() {
            List<Display> unmodifiableList = Collections.unmodifiableList(this);
            this.synchronizedList = Collections.synchronizedList(unmodifiableList);
        }
    }
}

