/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.credits;

import com.google.common.collect.Lists;
import dev.architectury.platform.Platform;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.rei.impl.client.gui.credits.CreditsEntryListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CreditsScreen
extends Screen {
    private Screen parent;
    private AbstractButton buttonDone;
    private CreditsEntryListWidget entryListWidget;

    public CreditsScreen(Screen parent) {
        super((Component)Component.m_237113_((String)""));
        this.parent = parent;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.m_6913_()) {
            this.openPrevious();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7856_() {
        this.entryListWidget = new CreditsEntryListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32);
        this.m_7787_((GuiEventListener)this.entryListWidget);
        this.entryListWidget.creditsClearEntries();
        ArrayList translators = Lists.newArrayList();
        Exception[] exception = new Exception[]{null};
        CreditsScreen.fillTranslators(exception, translators);
        List translatorsMapped = translators.stream().map(pair -> new Tuple((Object)("  " + (I18n.m_118936_((String)("language.roughlyenoughitems." + ((String)pair.m_14418_()).toLowerCase(Locale.ROOT).replace(' ', '_'))) ? I18n.m_118938_((String)("language.roughlyenoughitems." + ((String)pair.m_14418_()).toLowerCase(Locale.ROOT).replace(' ', '_')), (Object[])new Object[0]) : (String)pair.m_14418_())), (Object)((List)pair.m_14419_()))).collect(Collectors.toList());
        int i = this.f_96543_ - 80 - 6;
        for (String line : String.format("\u00a7lRoughly Enough Items (v%s)\n\u00a77Originally a fork for Almost Enough Items.\n\n\u00a7lLanguage Translation\n%s\n\n\u00a7lLicense\n\u00a77Roughly Enough Items is licensed under MIT.", Platform.getMod((String)"roughlyenoughitems").getVersion(), "%translators%").split("\n")) {
            if (line.equalsIgnoreCase("%translators%")) {
                if (exception[0] != null) {
                    this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.m_237113_((String)("Failed to get translators: " + exception[0].toString()))));
                    for (StackTraceElement traceElement : exception[0].getStackTrace()) {
                        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.m_237113_((String)("  at " + traceElement))));
                    }
                    continue;
                }
                int maxWidth = translatorsMapped.stream().mapToInt(pair -> this.f_96547_.m_92895_((String)pair.m_14418_())).max().orElse(0) + 5;
                for (Tuple pair2 : translatorsMapped) {
                    MutableComponent text = Component.m_237113_((String)"");
                    boolean isFirst = true;
                    for (TranslatorEntry entry : (List)pair2.m_14419_()) {
                        if (!isFirst) {
                            text = text.m_7220_((Component)Component.m_237113_((String)", "));
                        }
                        isFirst = false;
                        MutableComponent component = Component.m_237113_((String)entry.getName());
                        if (entry.proofreader) {
                            component = component.m_130940_(ChatFormatting.GOLD);
                        }
                        text = text.m_7220_((Component)component);
                    }
                    this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TranslationCreditsItem((Component)Component.m_237115_((String)((String)pair2.m_14418_())), (Component)text, i - maxWidth - 10, maxWidth));
                }
                continue;
            }
            this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.m_237113_((String)line)));
        }
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.m_237119_()));
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.LinkItem((Component)Component.m_237113_((String)"Visit the project at GitHub."), "https://www.github.com/shedaniel/RoughlyEnoughItems", this.entryListWidget.getItemWidth(), false));
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.LinkItem((Component)Component.m_237113_((String)"Visit the project page at CurseForge."), "https://www.curseforge.com/minecraft/mc-mods/roughly-enough-items", this.entryListWidget.getItemWidth(), false));
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.LinkItem((Component)Component.m_237113_((String)"Support the project via Patreon!"), "https://patreon.com/shedaniel", this.entryListWidget.getItemWidth(), true));
        this.entryListWidget.creditsAddEntry(new CreditsEntryListWidget.TextCreditsItem((Component)Component.m_237119_()));
        this.buttonDone = new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 26, 200, 20, (Component)Component.m_237115_((String)"gui.done"), button -> this.openPrevious(), Supplier::get){};
        this.m_142416_((GuiEventListener)this.buttonDone);
    }

    private static void fillTranslators(Exception[] exception, List<Tuple<String, List<TranslatorEntry>>> translators) {
        try {
            Class.forName("me.shedaniel.rei.impl.client.gui.credits.%s.CreditsScreenImpl".formatted(Platform.isForge() ? "forge" : "fabric")).getDeclaredMethod("fillTranslators", Exception[].class, List.class).invoke(null, exception, translators);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void openPrevious() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amountX, double amountY) {
        if (this.entryListWidget.m_6050_(mouseX, mouseY, amountX, amountY)) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amountX, amountY);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280039_(graphics);
        this.entryListWidget.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280137_(this.f_96547_, I18n.m_118938_((String)"text.rei.credits", (Object[])new Object[0]), this.f_96543_ / 2, 16, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    public static class TranslatorEntry {
        private final String name;
        private final boolean proofreader;

        public TranslatorEntry(String name) {
            this(name, false);
        }

        public TranslatorEntry(String name, boolean proofreader) {
            this.name = name;
            this.proofreader = proofreader;
        }

        public String getName() {
            return this.name;
        }
    }
}

