/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.config.entries.FilteringEntry;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.search.OverlaySearchField;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@ApiStatus.Internal
public class FilteringScreen
extends Screen {
    protected List<EntryStack<?>> selected = Lists.newArrayList();
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public int getMaxScrollHeight() {
            return Mth.m_14167_((float)((float)FilteringScreen.this.entryStacks.size() / ((float)FilteringScreen.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize() + 28;
        }

        public Rectangle getBounds() {
            return FilteringScreen.this.getBounds();
        }

        public int getScrollBarX(int maxX) {
            return FilteringScreen.this.f_96543_ - 7;
        }
    };
    Screen parent;
    private FilteringEntry filteringEntry;
    private Tooltip tooltip = null;
    private List<EntryStack<?>> entryStacks = null;
    private Rectangle innerBounds;
    private List<FilteringListEntry> entries = Collections.emptyList();
    private List<GuiEventListener> elements = Collections.emptyList();
    private List<PointPair> points = new ArrayList<PointPair>();
    private OverlaySearchField searchField;
    private Button selectAllButton;
    private Button selectNoneButton;
    private Button hideButton;
    private Button showButton;
    private Button backButton;
    private Predicate<Rectangle> selectionCache;
    private SearchFilter lastFilter = SearchFilter.matchAll();

    public FilteringScreen(FilteringEntry filteringEntry) {
        super((Component)Component.m_237115_((String)"config.roughlyenoughitems.filteringScreen"));
        this.filteringEntry = filteringEntry;
        this.searchField = new OverlaySearchField(0, 0, 0, 0);
        MutableComponent selectAllText = Component.m_237115_((String)"config.roughlyenoughitems.filteredEntries.selectAll");
        this.selectAllButton = Button.m_253074_((Component)selectAllText, button -> {
            this.points.clear();
            this.points.add(new PointPair(new Point(-1073741823, -1073741823), new Point(0x3FFFFFFF, 0x3FFFFFFF)));
        }).m_252987_(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)selectAllText) + 10, 20).m_253136_();
        MutableComponent selectNoneText = Component.m_237115_((String)"config.roughlyenoughitems.filteredEntries.selectNone");
        this.selectNoneButton = Button.m_253074_((Component)selectNoneText, button -> this.points.clear()).m_252987_(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)selectNoneText) + 10, 20).m_253136_();
        MutableComponent hideText = Component.m_237115_((String)"config.roughlyenoughitems.filteredEntries.hide");
        this.hideButton = Button.m_253074_((Component)hideText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                FilteringListEntry entry = this.entries.get(i);
                entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
                if (!entry.isSelected() || entry.isFiltered()) continue;
                filteringEntry.configFiltered.add(stack);
                filteringEntry.edited = true;
                entry.dirty = true;
            }
        }).m_252987_(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)hideText) + 10, 20).m_253136_();
        MutableComponent showText = Component.m_237115_((String)"config.roughlyenoughitems.filteredEntries.show");
        this.showButton = Button.m_253074_((Component)showText, button -> {
            for (int i = 0; i < this.entryStacks.size(); ++i) {
                EntryStack<?> stack = this.entryStacks.get(i);
                FilteringListEntry entry = this.entries.get(i);
                entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
                if (!entry.isSelected() || !filteringEntry.configFiltered.remove(stack)) continue;
                filteringEntry.edited = true;
                entry.dirty = true;
            }
        }).m_252987_(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)showText) + 10, 20).m_253136_();
        MutableComponent backText = Component.m_237113_((String)"\u21a9 ").m_7220_((Component)Component.m_237115_((String)"gui.back"));
        this.backButton = Button.m_253074_((Component)backText, button -> {
            this.f_96541_.m_91152_(this.parent);
            this.parent = null;
        }).m_252987_(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)backText) + 10, 20).m_253136_();
        this.searchField.isMain = false;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        int width = Math.max(Mth.m_14143_((float)((float)(bounds.width - 2 - 6) / (float)EntryListWidget.entrySize())), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)(width * EntryListWidget.entrySize()) / 2.0f), bounds.y + 5, width * EntryListWidget.entrySize(), bounds.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 30, this.f_96543_, this.f_96544_ - 30);
    }

    public void m_7856_() {
        super.m_7856_();
        Rectangle bounds = this.getBounds();
        this.updateSearch(this.searchField.getText());
        this.selectAllButton.m_252865_(2);
        this.selectAllButton.m_253211_(bounds.getMaxY() - 22);
        this.selectNoneButton.m_252865_(4 + this.selectAllButton.m_5711_());
        this.selectNoneButton.m_253211_(bounds.getMaxY() - 22);
        int searchFieldWidth = Math.max(bounds.width - (this.selectNoneButton.m_252754_() + this.selectNoneButton.m_5711_() + this.hideButton.m_5711_() + this.showButton.m_5711_() + 12), 100);
        this.searchField.getBounds().setBounds(this.selectNoneButton.m_252754_() + this.selectNoneButton.m_5711_() + 4, bounds.getMaxY() - 21, searchFieldWidth, 18);
        this.hideButton.m_252865_(bounds.getMaxX() - this.hideButton.m_5711_() - this.showButton.m_5711_() - 4);
        this.hideButton.m_253211_(bounds.getMaxY() - 22);
        this.showButton.m_252865_(bounds.getMaxX() - this.showButton.m_5711_() - 2);
        this.showButton.m_253211_(bounds.getMaxY() - 22);
        this.backButton.m_252865_(4);
        this.backButton.m_253211_(4);
        this.searchField.setResponder(this::updateSearch);
    }

    protected void renderHoleBackground(GuiGraphics graphics, int y1, int y2, int tint, int alpha1, int alpha2) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_279548_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float float_1 = 32.0f;
        RenderSystem.setShader(GameRenderer::m_172820_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, (float)y2, 0.0f).m_7421_(0.0f, (float)y2 / 32.0f).m_6122_(tint, tint, tint, alpha2).m_5752_();
        buffer.m_252986_(matrix, (float)this.f_96543_, (float)y2, 0.0f).m_7421_((float)this.f_96543_ / 32.0f, (float)y2 / 32.0f).m_6122_(tint, tint, tint, alpha2).m_5752_();
        buffer.m_252986_(matrix, (float)this.f_96543_, (float)y1, 0.0f).m_7421_((float)this.f_96543_ / 32.0f, (float)y1 / 32.0f).m_6122_(tint, tint, tint, alpha1).m_5752_();
        buffer.m_252986_(matrix, 0.0f, (float)y1, 0.0f).m_7421_(0.0f, (float)y1 / 32.0f).m_6122_(tint, tint, tint, alpha1).m_5752_();
        tesselator.m_85914_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int nextIndex;
        this.renderHoleBackground(graphics, 0, this.f_96544_, 32, 255, 255);
        this.updateSelectionCache();
        Rectangle bounds = this.getBounds();
        this.tooltip = null;
        if (bounds.isEmpty()) {
            return;
        }
        ScissorsHandler.INSTANCE.scissor(bounds);
        for (FilteringListEntry entry : this.entries) {
            entry.clearStacks();
        }
        int skip = Math.max(0, Mth.m_14107_((double)(this.scrolling.scrollAmount() / (double)EntryListWidget.entrySize())));
        BatchedEntryRendererManager<FilteringListEntry> manager = new BatchedEntryRendererManager<FilteringListEntry>();
        for (int i = nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize(); i < this.entryStacks.size(); ++i) {
            EntryStack<?> stack = this.entryStacks.get(i);
            FilteringListEntry entry = this.entries.get(nextIndex);
            entry.getBounds().y = entry.backupY - this.scrolling.scrollAmountInt();
            if (entry.getBounds().y > bounds.getMaxY()) break;
            entry.entry((EntryStack)stack);
            manager.add(entry);
            ++nextIndex;
        }
        manager.render(graphics, mouseX, mouseY, delta);
        this.updatePosition(delta);
        this.scrolling.renderScrollBar(graphics, 0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        this.searchField.m_88315_(graphics, mouseX, mouseY, delta);
        this.selectAllButton.m_88315_(graphics, mouseX, mouseY, delta);
        this.selectNoneButton.m_88315_(graphics, mouseX, mouseY, delta);
        this.hideButton.m_88315_(graphics, mouseX, mouseY, delta);
        this.showButton.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280168_().m_85849_();
        ScissorsHandler.INSTANCE.removeLastScissor();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.setShader(GameRenderer::m_172820_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, 0.0f, (float)(bounds.y + 4), 0.0f).m_7421_(0.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)this.f_96543_, (float)(bounds.y + 4), 0.0f).m_7421_(1.0f, 1.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(matrix, (float)this.f_96543_, (float)bounds.y, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        buffer.m_252986_(matrix, 0.0f, (float)bounds.y, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(0, 0, 0, 255).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        this.renderHoleBackground(graphics, 0, bounds.y, 64, 255, 255);
        this.backButton.m_88315_(graphics, mouseX, mouseY, delta);
        if (this.tooltip != null) {
            ((ScreenOverlayImpl)REIRuntime.getInstance().getOverlay().get()).renderTooltip(graphics, this.tooltip);
        }
        graphics.m_280648_(this.f_96547_, this.f_96539_.m_7532_(), (int)((float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f), 12, -1);
        MutableComponent hint = Component.m_237115_((String)"config.roughlyenoughitems.filteringRulesScreen.hint").m_130940_(ChatFormatting.YELLOW);
        graphics.m_280430_(this.f_96547_, (Component)hint, this.f_96543_ - this.f_96547_.m_92852_((FormattedText)hint) - 15, 12, -1);
    }

    private Predicate<Rectangle> getSelection() {
        return this.selectionCache;
    }

    private void updateSelectionCache() {
        if (!this.points.isEmpty()) {
            Predicate<Rectangle> predicate = rect -> false;
            for (PointPair pair : this.points) {
                Point firstPoint = pair.firstPoint();
                Point secondPoint = pair.secondPoint();
                if (secondPoint == null) {
                    secondPoint = PointHelper.ofMouse();
                    secondPoint.translate(0, this.scrolling.scrollAmountInt());
                }
                int left = Math.min(firstPoint.x, secondPoint.x);
                int top = Math.min(firstPoint.y, secondPoint.y);
                int right = Math.max(firstPoint.x, secondPoint.x);
                int bottom = Math.max(firstPoint.y, secondPoint.y);
                Rectangle rectangle = new Rectangle(left, top - this.scrolling.scrollAmountInt(), Math.max(1, right - left), Math.max(1, bottom - top));
                predicate = predicate.or(arg_0 -> ((Rectangle)rectangle).intersects(arg_0));
            }
            this.selectionCache = predicate;
            return;
        }
        this.selectionCache = rect -> false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    private void updatePosition(float delta) {
        this.scrolling.updatePosition(delta);
    }

    public void updateSearch(String searchTerm) {
        this.lastFilter = SearchProvider.getInstance().createFilter(searchTerm);
        LinkedHashSet list = Sets.newLinkedHashSet();
        ((Stream)EntryRegistry.getInstance().getEntryStacks().parallel()).filter(this::matches).map(EntryStack::normalize).forEachOrdered(list::add);
        this.entryStacks = Lists.newArrayList((Iterable)list);
        this.updateEntriesPosition();
    }

    public boolean matches(EntryStack<?> stack) {
        EntrySerializer<?> serializer = stack.getDefinition().getSerializer();
        if (serializer == null || !serializer.supportReading() || !serializer.supportSaving()) {
            return false;
        }
        return this.lastFilter.test(stack);
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        this.innerBounds = FilteringScreen.updateInnerBounds(this.getBounds());
        int width = this.innerBounds.width / entrySize;
        int pageHeight = this.innerBounds.height / entrySize;
        int slotsToPrepare = Math.max(this.entryStacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * entrySize + this.innerBounds.x;
            int yPos = currentY * entrySize + this.innerBounds.y;
            entries.add(new FilteringListEntry(xPos, yPos, entrySize));
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
        this.elements = Lists.newArrayList((Iterable)entries);
        this.elements.add((GuiEventListener)this.searchField);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.elements;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        if (this.getBounds().contains(mouseX, mouseY)) {
            if (this.searchField.m_6375_(mouseX, mouseY, button)) {
                this.points.clear();
                return true;
            }
            if (this.selectAllButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.selectNoneButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.hideButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.showButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (button == 0) {
                if (!Screen.m_96638_()) {
                    this.points.clear();
                }
                this.points.add(new PointPair(new Point(mouseX, mouseY + this.scrolling.scrollAmount()), null));
                return true;
            }
        }
        return this.backButton.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        PointPair pair;
        if (button == 0 && !this.points.isEmpty() && (pair = this.points.get(this.points.size() - 1)).secondPoint() == null) {
            this.points.set(this.points.size() - 1, new PointPair(pair.firstPoint(), new Point(mouseX, mouseY + this.scrolling.scrollAmount())));
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char chr, int keyCode) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_5534_(chr, keyCode)) continue;
            return true;
        }
        return super.m_5534_(chr, keyCode);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        if (Screen.m_96634_((int)keyCode)) {
            this.points.clear();
            this.points.add(new PointPair(new Point(-1073741823, -1073741823), new Point(0x3FFFFFFF, 0x3FFFFFFF)));
            return true;
        }
        if (keyCode == 256 && this.m_6913_()) {
            this.backButton.m_5691_();
            return true;
        }
        return false;
    }

    public void updateArea(@Nullable String searchTerm) {
        if (searchTerm != null) {
            this.updateSearch(searchTerm);
        } else if (this.entryStacks == null) {
            this.updateSearch("");
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean m_6050_(double double_1, double double_2, double amountX, double amountY) {
        if (this.getBounds().contains(double_1, double_2) && amountY != 0.0) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
            return true;
        }
        super.m_6050_(double_1, double_2, amountX, amountY);
        return true;
    }

    private class FilteringListEntry
    extends EntryWidget {
        private int backupY;
        private boolean filtered;
        private boolean dirty;

        private FilteringListEntry(int x, int y, int entrySize) {
            super(new Point(x, y));
            this.filtered = false;
            this.dirty = true;
            this.backupY = y;
            this.getBounds().width = this.getBounds().height = entrySize;
            this.interactableFavorites(false);
            this.interactable(false);
            this.noHighlight();
        }

        @Override
        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && FilteringScreen.this.getBounds().contains(mouseX, mouseY);
        }

        @Override
        protected void drawExtra(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.isSelected()) {
                Rectangle bounds = this.getBounds();
                RenderSystem.disableDepthTest();
                graphics.m_280024_(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -1989447430, -1989447430);
                RenderSystem.enableDepthTest();
            }
        }

        public boolean isSelected() {
            return FilteringScreen.this.getSelection().test(this.getBounds());
        }

        public boolean isFiltered() {
            if (this.dirty) {
                this.filtered = FilteringScreen.this.filteringEntry.configFiltered.contains(this.getCurrentEntry());
                this.dirty = false;
            }
            return this.filtered;
        }

        @Override
        protected void drawBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.isFiltered()) {
                Rectangle bounds = this.getBounds();
                RenderSystem.disableDepthTest();
                graphics.m_280024_(bounds.x, bounds.y, bounds.getMaxX(), bounds.getMaxY(), -65536, -65536);
                RenderSystem.enableDepthTest();
            }
        }

        @Override
        protected void queueTooltip(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (FilteringScreen.this.searchField.containsMouse(mouseX, mouseY)) {
                return;
            }
            Tooltip tooltip = this.getCurrentTooltip(TooltipContext.of(new Point(mouseX, mouseY)));
            if (tooltip != null) {
                FilteringScreen.this.tooltip = tooltip;
            }
        }
    }

    private record PointPair(Point firstPoint, @Nullable Point secondPoint) {
    }
}

