/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelResource;
import org.popcraft.chunky.platform.Border;
import org.popcraft.chunky.platform.ForgeBorder;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Location;
import org.popcraft.chunky.util.Input;

public class ForgeWorld
implements World {
    private static final int TICKING_LOAD_DURATION = Input.tryInteger(System.getProperty("chunky.tickingLoadDuration")).orElse(0);
    private static final TicketType<Unit> CHUNKY = TicketType.m_9462_((String)"chunky", (unit, unit2) -> 0);
    private static final TicketType<Unit> CHUNKY_TICKING = TicketType.m_9465_((String)"%s_ticking".formatted("chunky"), (unit, unit2) -> 0, (int)(TICKING_LOAD_DURATION * 20));
    private final ServerLevel world;
    private final Border worldBorder;

    public ForgeWorld(ServerLevel world) {
        this.world = world;
        this.worldBorder = new ForgeBorder(world.m_6857_());
    }

    @Override
    public String getName() {
        return this.world.m_46472_().m_135782_().toString();
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    @Override
    public CompletableFuture<Boolean> isChunkGenerated(int x, int z) {
        if (Thread.currentThread() != this.world.m_7654_().m_6304_()) {
            return CompletableFuture.supplyAsync(() -> this.isChunkGenerated(x, z), (Executor)this.world.m_7654_()).join();
        }
        ChunkMap chunkStorage = this.world.m_7726_().f_8325_;
        ChunkPos chunkPos = new ChunkPos(x, z);
        ChunkHolder loadedChunkHolder = chunkStorage.m_140327_(chunkPos.m_45588_());
        if (loadedChunkHolder != null && loadedChunkHolder.m_140088_() == ChunkStatus.f_62326_) {
            return CompletableFuture.completedFuture(true);
        }
        ChunkHolder unloadedChunkHolder = (ChunkHolder)chunkStorage.f_140131_.get(chunkPos.m_45588_());
        if (unloadedChunkHolder != null && unloadedChunkHolder.m_140088_() == ChunkStatus.f_62326_) {
            return CompletableFuture.completedFuture(true);
        }
        return chunkStorage.m_214963_(chunkPos).thenApply(optionalNbt -> optionalNbt.filter(chunkNbt -> chunkNbt.m_128425_("Status", 8)).map(chunkNbt -> chunkNbt.m_128461_("Status")).map(status -> "minecraft:full".equals(status) || "full".equals(status)).orElse(false));
    }

    @Override
    public CompletableFuture<Void> getChunkAtAsync(int x, int z) {
        if (Thread.currentThread() != this.world.m_7654_().m_6304_()) {
            return CompletableFuture.supplyAsync(() -> this.getChunkAtAsync(x, z), (Executor)this.world.m_7654_()).join();
        }
        ChunkPos chunkPos = new ChunkPos(x, z);
        ServerChunkCache serverChunkCache = this.world.m_7726_();
        serverChunkCache.m_8387_(CHUNKY, chunkPos, 0, (Object)Unit.INSTANCE);
        if (TICKING_LOAD_DURATION > 0) {
            serverChunkCache.m_8387_(CHUNKY_TICKING, chunkPos, 1, (Object)Unit.INSTANCE);
        }
        serverChunkCache.m_8489_();
        ChunkMap chunkManager = serverChunkCache.f_8325_;
        ChunkHolder chunkHolder = chunkManager.m_140327_(chunkPos.m_45588_());
        CompletableFuture<Object> chunkFuture = chunkHolder == null ? CompletableFuture.completedFuture(null) : CompletableFuture.allOf(chunkHolder.m_140049_(ChunkStatus.f_62326_, chunkManager));
        chunkFuture.whenCompleteAsync((ignored, throwable) -> serverChunkCache.m_8438_(CHUNKY, chunkPos, 0, (Object)Unit.INSTANCE), (Executor)this.world.m_7654_());
        return chunkFuture;
    }

    @Override
    public UUID getUUID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSeaLevel() {
        return this.world.m_5736_();
    }

    @Override
    public Location getSpawn() {
        BlockPos pos = this.world.m_220360_();
        float rot = this.world.m_220361_();
        return new Location(this, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), rot, 0.0f);
    }

    @Override
    public Border getWorldBorder() {
        return this.worldBorder;
    }

    @Override
    public int getElevation(int x, int z) {
        int logicalHeight;
        int height = this.world.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z) + 1;
        if (height >= (logicalHeight = this.world.m_143344_())) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, logicalHeight, z);
            int air = 0;
            while (pos.m_123342_() > this.world.m_141937_()) {
                BlockState blockState = this.world.m_8055_((BlockPos)(pos = pos.m_122173_(Direction.DOWN)));
                if (blockState.m_280296_() && air > 1) {
                    return pos.m_123342_() + 1;
                }
                air = blockState.m_60795_() ? air + 1 : 0;
            }
        }
        return height;
    }

    @Override
    public int getMaxElevation() {
        return this.world.m_143344_();
    }

    @Override
    public void playEffect(Player player, String effect) {
        Location location = player.getLocation();
        BlockPos pos = BlockPos.m_274561_((double)location.getX(), (double)location.getY(), (double)location.getZ());
        Input.tryInteger(effect).ifPresent(eventId -> this.world.m_46796_(eventId.intValue(), pos, 0));
    }

    @Override
    public void playSound(Player player, String sound) {
        Location location = player.getLocation();
        this.world.m_7654_().m_206579_().m_6632_(Registries.f_256840_).flatMap(soundEventRegistry -> soundEventRegistry.m_6612_(ResourceLocation.m_135820_((String)sound))).ifPresent(soundEvent -> this.world.m_6263_(null, location.getX(), location.getY(), location.getZ(), soundEvent, SoundSource.MASTER, 2.0f, 1.0f));
    }

    @Override
    public Optional<Path> getDirectory(String name) {
        if (name == null) {
            return Optional.empty();
        }
        Path directory = DimensionType.m_196975_((ResourceKey)this.world.m_46472_(), (Path)this.world.m_7654_().m_129843_(LevelResource.f_78182_)).normalize().resolve(name);
        return Files.exists(directory, new LinkOption[0]) ? Optional.of(directory) : Optional.empty();
    }

    public ServerLevel getWorld() {
        return this.world;
    }
}

