/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import dev.foxgirl.trimeffects.TrimEffects;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public final class Config {
    public double secondsMaximum = 14.0;
    public double secondsMinimum = 12.0;
    public double absorptionStunSeconds = 10.0;
    @NotNull
    public Map<String, String> effects = new LinkedHashMap<String, String>();
    @NotNull
    public Map<String, Integer> strengths = new LinkedHashMap<String, Integer>();
    private static final Config DEFAULT = new Config();
    private static final Gson GSON;

    @NotNull
    public Parsed parse() {
        return new Parsed(this);
    }

    @NotNull
    public static Config read() {
        Path pathDirectory = FMLPaths.CONFIGDIR.get();
        Path pathFile = pathDirectory.resolve("trimeffects-config.json");
        Path pathTemp = pathDirectory.resolve("trimeffects-config.json.tmp");
        try {
            return (Config)GSON.fromJson((Reader)Files.newBufferedReader(pathFile), Config.class);
        }
        catch (NoSuchFileException cause) {
            TrimEffects.LOGGER.error("Failed to read config, file not found");
        }
        catch (IOException cause) {
            TrimEffects.LOGGER.error("Failed to read config, IO error", (Throwable)cause);
        }
        catch (JsonParseException cause) {
            TrimEffects.LOGGER.error("Failed to read config, JSON error", (Throwable)cause);
        }
        catch (Exception cause) {
            TrimEffects.LOGGER.error("Failed to read config", (Throwable)cause);
        }
        try {
            Files.writeString(pathTemp, (CharSequence)GSON.toJson((Object)DEFAULT), new OpenOption[0]);
            Files.move(pathTemp, pathFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException cause) {
            TrimEffects.LOGGER.error("Failed to write new config, IO error", (Throwable)cause);
        }
        catch (Exception cause) {
            TrimEffects.LOGGER.error("Failed to write new config", (Throwable)cause);
        }
        return DEFAULT;
    }

    static {
        Config.DEFAULT.effects.put("spire", "strength");
        Config.DEFAULT.effects.put("eye", "regeneration");
        Config.DEFAULT.effects.put("snout", "fire_resistance");
        Config.DEFAULT.effects.put("rib", "haste");
        Config.DEFAULT.effects.put("vex", "invisibility");
        Config.DEFAULT.effects.put("ward", "absorption");
        Config.DEFAULT.effects.put("tide", "luck");
        Config.DEFAULT.effects.put("wild", "hero_of_the_village");
        Config.DEFAULT.effects.put("coast", "water_breathing");
        Config.DEFAULT.effects.put("dune", "speed");
        Config.DEFAULT.effects.put("sentry", "resistance");
        Config.DEFAULT.effects.put("wayfinder", "jump_boost");
        Config.DEFAULT.effects.put("shaper", "saturation");
        Config.DEFAULT.effects.put("silence", "night_vision");
        Config.DEFAULT.effects.put("raiser", "saturation");
        Config.DEFAULT.effects.put("host", "glowing");
        Config.DEFAULT.strengths.put("diamond", 1);
        Config.DEFAULT.strengths.put("netherite", 2);
        GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().setLenient().create();
    }

    public static final class Parsed {
        private final double secondsMaximum;
        private final double secondsMinimum;
        private final double absorptionStunSeconds;
        private final Map<ResourceKey<TrimPattern>, ResourceKey<MobEffect>> effects = new LinkedHashMap<ResourceKey<TrimPattern>, ResourceKey<MobEffect>>();
        private final Map<ResourceKey<TrimMaterial>, Integer> strengths = new LinkedHashMap<ResourceKey<TrimMaterial>, Integer>();

        private Parsed(@NotNull Config config) {
            Object value;
            String key;
            this.secondsMaximum = config.secondsMaximum;
            this.secondsMinimum = config.secondsMinimum;
            this.absorptionStunSeconds = config.absorptionStunSeconds;
            for (Map.Entry<String, String> entry : config.effects.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value == null || key == null) continue;
                this.effects.put((ResourceKey<TrimPattern>)ResourceKey.m_135785_((ResourceKey)Registries.f_266063_, (ResourceLocation)new ResourceLocation(key)), (ResourceKey<MobEffect>)ResourceKey.m_135785_((ResourceKey)Registries.f_256929_, (ResourceLocation)new ResourceLocation((String)value)));
            }
            for (Map.Entry<String, Object> entry : config.strengths.entrySet()) {
                key = entry.getKey();
                value = (Integer)entry.getValue();
                if (value == null || key == null) continue;
                this.strengths.put((ResourceKey<TrimMaterial>)ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)new ResourceLocation(key)), (Integer)value);
            }
        }

        public double getSecondsMaximum() {
            return this.secondsMaximum;
        }

        public double getSecondsMinimum() {
            return this.secondsMinimum;
        }

        public double getAbsorptionStunSeconds() {
            return this.absorptionStunSeconds;
        }

        @NotNull
        public Map<ResourceKey<TrimPattern>, ResourceKey<MobEffect>> getEffects() {
            return this.effects;
        }

        @NotNull
        public Map<ResourceKey<TrimMaterial>, Integer> getStrengths() {
            return this.strengths;
        }
    }
}

