/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.resourcepacks;

import com.google.common.collect.ImmutableSet;
import de.maxhenkel.voicechat.Voicechat;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;

public class VoiceChatResourcePack
extends AbstractPackResources
implements Pack.ResourcesSupplier {
    public VoiceChatResourcePack(String id) {
        super(id, true);
    }

    public Pack toPack(Component name) {
        int packVersion = SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES);
        Pack.Info info = Pack.m_246334_((String)"", (Pack.ResourcesSupplier)this, (int)packVersion);
        if (info == null) {
            throw new IllegalStateException("Could not find builtin resource pack info");
        }
        return Pack.m_245512_((String)this.m_5542_(), (Component)name, (boolean)false, (Pack.ResourcesSupplier)this, (Pack.Info)info, (Pack.Position)Pack.Position.TOP, (boolean)false, (PackSource)PackSource.f_10528_);
    }

    private String getPath() {
        return "/packs/" + this.m_5542_() + "/";
    }

    @Nullable
    private InputStream get(String name) {
        return Voicechat.class.getResourceAsStream(this.getPath() + name);
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... strings) {
        return this.getResource(String.join((CharSequence)"/", strings));
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation resourceLocation) {
        return this.m_8017_(packType.m_10305_(), resourceLocation.m_135827_(), resourceLocation.m_135815_());
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String path) {
        InputStream resourceAsStream = this.get(path);
        if (resourceAsStream == null) {
            return null;
        }
        return () -> resourceAsStream;
    }

    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput resourceOutput) {
        try {
            URL url = Voicechat.class.getResource(this.getPath());
            if (url == null) {
                return;
            }
            Path namespacePath = Paths.get(url.toURI()).resolve(type.m_10305_()).resolve(namespace);
            Path resPath = namespacePath.resolve(prefix);
            if (!Files.exists(resPath, new LinkOption[0])) {
                return;
            }
            try (Stream<Path> files = Files.walk(resPath, new FileVisitOption[0]);){
                files.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ResourceLocation resourceLocation = new ResourceLocation(namespace, VoiceChatResourcePack.convertPath(path).substring(VoiceChatResourcePack.convertPath(namespacePath).length() + 1));
                    resourceOutput.accept((Object)resourceLocation, this.m_214146_(type, resourceLocation));
                });
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to list builtin pack resources", e);
        }
    }

    private static String convertPath(Path path) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < path.getNameCount(); ++i) {
            stringBuilder.append(path.getName(i));
            if (i >= path.getNameCount() - 1) continue;
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public Set<String> m_5698_(PackType packType) {
        if (packType == PackType.CLIENT_RESOURCES) {
            return ImmutableSet.of((Object)"voicechat");
        }
        return ImmutableSet.of();
    }

    public void close() {
    }

    public PackResources m_293078_(String string) {
        return this;
    }

    public PackResources m_247679_(String string, Pack.Info info) {
        return this;
    }
}

