/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.Channel;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.EventNetworkChannel;
import net.minecraftforge.network.NetworkDirection;

public class ForgeNetManager
extends NetManager {
    @Override
    public <T extends Packet<T>> Channel<T> registerReceiver(Class<T> packetType, boolean toClient, boolean toServer) {
        Channel c = new Channel();
        try {
            Packet dummyPacket = (Packet)packetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            EventNetworkChannel channel = ChannelBuilder.named((ResourceLocation)dummyPacket.getIdentifier()).acceptedVersions((status, version) -> true).optional().networkProtocolVersion(Voicechat.COMPATIBILITY_VERSION).eventNetworkChannel();
            channel.addListener(event -> {
                if (event.getPayload() == null) {
                    return;
                }
                CustomPayloadEvent.Context context = event.getSource();
                if (toServer && context.getDirection().equals((Object)NetworkDirection.PLAY_TO_SERVER)) {
                    try {
                        if (!Voicechat.SERVER.isCompatible(context.getSender()) && !packetType.equals(RequestSecretPacket.class)) {
                            return;
                        }
                        Packet packet = (Packet)packetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        packet.fromBytes(event.getPayload());
                        c.onServerPacket(context.getSender().f_8924_, context.getSender(), context.getSender().f_8906_, packet);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    if (this.isSameThread()) {
                        return;
                    }
                    try {
                        Packet packet = (Packet)packetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        packet.fromBytes(event.getPayload());
                        this.onClientPacket(c, packet);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return c;
    }

    @Override
    public void sendToServer(Packet<?> packet, ClientPacketListener connection) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        packet.toBytes(buffer);
        connection.m_295327_(NetworkDirection.PLAY_TO_SERVER.buildPacket(buffer, packet.getIdentifier()).getThis());
    }

    @Override
    public void sendToClient(Packet<?> packet, ServerPlayer player) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        packet.toBytes(buffer);
        player.f_8906_.m_141995_(NetworkDirection.PLAY_TO_CLIENT.buildPacket(buffer, packet.getIdentifier()).getThis());
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T extends Packet<T>> void onClientPacket(Channel<T> channel, T packet) {
        channel.onClientPacket(Minecraft.m_91087_(), Minecraft.m_91087_().m_91403_(), packet);
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean isSameThread() {
        return Minecraft.m_91087_().m_18695_();
    }
}

