/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.debug.VoicechatUncaughtExceptionHandler;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.MicThread;
import de.maxhenkel.voicechat.voice.client.MicrophoneException;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerManager;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class MicTestButton
extends AbstractButton {
    private static final Component TEST_UNAVAILABLE = Component.m_237115_((String)"message.voicechat.mic_test_unavailable");
    private static final Component TEST_ON = Component.m_237115_((String)"message.voicechat.mic_test_on");
    private static final Component TEST_OFF = Component.m_237115_((String)"message.voicechat.mic_test_off");
    private boolean micActive;
    @Nullable
    private VoiceThread voiceThread;
    private final MicListener micListener;
    @Nullable
    private final ClientVoicechat client;

    public MicTestButton(int xIn, int yIn, int widthIn, int heightIn, MicListener micListener) {
        super(xIn, yIn, widthIn, heightIn, (Component)Component.m_237119_());
        this.micListener = micListener;
        this.client = ClientManager.getClient();
        this.f_93623_ = this.client == null || this.client.getSoundManager() != null;
        this.updateText();
    }

    private void updateText() {
        if (!this.f_93623_) {
            this.m_93666_(TEST_UNAVAILABLE);
            return;
        }
        if (this.micActive) {
            this.m_93666_(TEST_ON);
        } else {
            this.m_93666_(TEST_OFF);
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_87963_(guiGraphics, x, y, partialTicks);
        if (this.voiceThread != null) {
            this.voiceThread.updateLastRender();
        }
    }

    public void setMicActive(boolean micActive) {
        this.micActive = micActive;
        this.updateText();
    }

    public void m_5691_() {
        this.setMicActive(!this.micActive);
        if (this.micActive) {
            this.close();
            try {
                this.voiceThread = new VoiceThread(e -> {
                    this.setMicActive(false);
                    this.f_93623_ = false;
                    e.printStackTrace();
                });
                this.voiceThread.start();
            }
            catch (Exception e2) {
                this.setMicActive(false);
                this.f_93623_ = false;
                e2.printStackTrace();
            }
        } else {
            this.close();
        }
        this.updateText();
    }

    private void close() {
        if (this.voiceThread != null) {
            this.voiceThread.close();
            this.voiceThread = null;
        }
    }

    public void stop() {
        this.close();
        this.setMicActive(false);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        this.m_168802_(narrationElementOutput);
    }

    public static interface MicListener {
        public void onMicValue(double var1);
    }

    private class VoiceThread
    extends Thread {
        private final Speaker speaker;
        private boolean running = true;
        private long lastRender;
        private MicThread micThread;
        private boolean usesOwnMicThread;
        @Nullable
        private SoundManager ownSoundManager;

        public VoiceThread(Consumer<MicrophoneException> onMicError) throws SpeakerException {
            SoundManager soundManager;
            this.setDaemon(true);
            this.setName("VoiceTestingThread");
            this.setUncaughtExceptionHandler(new VoicechatUncaughtExceptionHandler());
            MicThread micThread = this.micThread = MicTestButton.this.client != null ? MicTestButton.this.client.getMicThread() : null;
            if (this.micThread == null) {
                this.micThread = new MicThread(MicTestButton.this.client, null, onMicError);
                this.usesOwnMicThread = true;
            }
            if (MicTestButton.this.client == null) {
                this.ownSoundManager = soundManager = new SoundManager(VoicechatClient.CLIENT_CONFIG.speaker.get());
            } else {
                soundManager = MicTestButton.this.client.getSoundManager();
            }
            if (soundManager == null) {
                throw new SpeakerException("No sound manager");
            }
            this.speaker = SpeakerManager.createSpeaker(soundManager, null);
            this.updateLastRender();
            this.setMicLocked(true);
        }

        @Override
        public void run() {
            while (this.running && System.currentTimeMillis() - this.lastRender <= 500L) {
                short[] buff = this.micThread.pollMic();
                if (buff == null) continue;
                MicTestButton.this.micListener.onMicValue(Utils.dbToPerc(Utils.getHighestAudioLevel(buff)));
                this.speaker.play(buff, VoicechatClient.CLIENT_CONFIG.voiceChatVolume.get().floatValue(), null);
            }
            this.speaker.close();
            this.setMicLocked(false);
            MicTestButton.this.micListener.onMicValue(0.0);
            if (this.usesOwnMicThread) {
                this.micThread.close();
            }
            if (this.ownSoundManager != null) {
                this.ownSoundManager.close();
            }
            Voicechat.LOGGER.info("Mic test audio channel closed", new Object[0]);
        }

        public void updateLastRender() {
            this.lastRender = System.currentTimeMillis();
        }

        private void setMicLocked(boolean locked) {
            this.micThread.setMicrophoneLocked(locked);
        }

        public void close() {
            if (!this.running) {
                return;
            }
            Voicechat.LOGGER.info("Stopping mic test audio channel", new Object[0]);
            this.running = false;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

