/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.group.JoinGroupEntry;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class JoinGroupList
extends ListScreenListBase<JoinGroupEntry> {
    protected final ListScreenBase parent;

    public JoinGroupList(ListScreenBase parent, int width, int height, int top, int itemSize) {
        super(width, height, top, itemSize);
        this.parent = parent;
        this.m_93488_(false);
        this.updateGroups();
    }

    private void updateGroups() {
        Map<UUID, JoinGroupEntry.Group> groups = ClientManager.getGroupManager().getGroups().stream().collect(Collectors.toMap(ClientGroup::getId, JoinGroupEntry.Group::new));
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates(true);
        for (PlayerState state : playerStates) {
            JoinGroupEntry.Group group2;
            if (!state.hasGroup() || (group2 = groups.get(state.getGroup())) == null) continue;
            group2.getMembers().add(state);
        }
        groups.values().forEach(group -> group.getMembers().sort(Comparator.comparing(PlayerState::getName)));
        this.m_5988_(groups.values().stream().map(group -> new JoinGroupEntry(this.parent, (JoinGroupEntry.Group)group)).sorted(Comparator.comparing(o -> o.getGroup().getGroup().getName())).collect(Collectors.toList()));
    }

    public static void update() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof JoinGroupScreen) {
            JoinGroupScreen joinGroupScreen = (JoinGroupScreen)screen;
            joinGroupScreen.groupList.updateGroups();
        }
    }

    public boolean isEmpty() {
        return this.m_6702_().isEmpty();
    }
}

